/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Drazen Cindric (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.clusterconfig;

/**
 * Exception class for ClusterConfig specific exception.
 */
public class ClusterConfigException extends Exception {
  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 1L;

  /**
   * constructor with message.
   * 
   * @param message
   *          detailed error message.
   */
  public ClusterConfigException(String message) {
    super(message);
  }

  /**
   * constructor with causing exception.
   * 
   * @param cause
   *          exception that caused the error.
   */
  public ClusterConfigException(Throwable cause) {
    super(cause);
  }

  /**
   * constructor with message and causing exception.
   * 
   * @param message
   *          detailed error message.
   * @param cause
   *          exception that caused the error.
   */
  public ClusterConfigException(String message, Throwable cause) {
    super(message, cause);
  }
}
