/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky, Andreas Schank (both Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client;

/**
 * Helper class to provide resources for the TaskManager REST API.
 */
public final class TaskManagerClientHelper {

  /** The TaskManager's root context is fixed. */
  private static final String ROOT_CONTEXT = "/taskmanager/";

  /**
   * Private constructor to prevent construction of this utility class.
   */
  private TaskManagerClientHelper() {
    ;// do nothing.
  }

  /**
   * @return the resource to request a task for a given worker.
   */
  public static String getTaskRequestResource(final String workerName) {
    return ROOT_CONTEXT + workerName + "/";
  }

  /**
   * @return the resource to request a task for a given worker on a given host (a scaling worker should use this).
   */
  public static String getTaskRequestForWorkerHostResource(final String workerName, final String workerHost) {
    return getTaskRequestResource(workerName) + "?workerHost=" + workerHost;
  }

  /**
   * @return the resource to request an initial task for a given worker in a running job.
   */
  public static String getInitialTaskRequestResource(final String workerName, final String jobName) {
    return getTaskRequestResource(workerName) + "initialTask/" + jobName + "/";
  }

  /**
   * @return the resource to finish (or send keep-alive) for a task with the given taskId for a given worker.
   */
  public static String getTaskResource(final String workerName, final String taskId) {
    return getTaskRequestResource(workerName) + taskId + "/";
  }
}
