/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.ontology.SesameOntologyManager;
import org.eclipse.smila.ontology.activator.Activator;
import org.eclipse.smila.ontology.records.SesameValueHelper;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public abstract class ASesameRecordPipelet
implements Pipelet {
    public static final String PARAM_RECORDFILTER = "recordFilter";
    public static final String PARAM_REPOSITORY = "sesameRepository";
    protected AnyMap _configuration;
    protected SesameValueHelper _valueHelper = SesameValueHelper.INSTANCE;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    protected SesameOntologyManager getSesameOntologyManager() throws ProcessingException {
        SesameOntologyManager manager = Activator.getInstance().getService();
        if (manager == null) {
            throw new ProcessingException("no SesameOntologyManager service available.");
        }
        return manager;
    }

    protected ParameterAccessor getParameters(Blackboard blackboard) {
        return new ParameterAccessor(blackboard).setPipeletConfiguration(this._configuration);
    }

    protected RepositoryConnection getRepositoryConnection(ParameterAccessor parameters) throws ProcessingException {
        String repoName = parameters.getParameter(PARAM_REPOSITORY, null);
        SesameOntologyManager manager = this.getSesameOntologyManager();
        if (repoName == null) {
            try {
                return manager.getDefaultConnection();
            }
            catch (RepositoryException ex) {
                throw new ProcessingException("Could not get connection to default repository", (Throwable)ex);
            }
        }
        try {
            return manager.getConnection(repoName);
        }
        catch (RepositoryException ex) {
            throw new ProcessingException("Could not get connection to repository '" + repoName + "'", (Throwable)ex);
        }
    }

    protected URI createUri(RepositoryConnection connection, String uriString) {
        return this._valueHelper.createUri(connection, uriString);
    }
}

