/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.ontology.records.SesameValueHelper;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SesameRecordWriter {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final RepositoryConnection _repoConn;
    private Collection<Statement> _addStmts;
    private Collection<Statement> _clearStmts;
    private final SesameValueHelper _valueHelper = SesameValueHelper.INSTANCE;

    public SesameRecordWriter(RepositoryConnection repoConn) {
        this._repoConn = repoConn;
    }

    public URI writeBlackboardRecord(Blackboard blackboard, String id, String defaultTypeUri, String uriAttribute) throws BlackboardAccessException, RepositoryException {
        Record record = blackboard.getRecord(id);
        return this.writeRecord(record, defaultTypeUri, uriAttribute);
    }

    public URI writeRecord(Record record, String defaultTypeUri, String uriAttribute) throws RepositoryException {
        boolean commit = false;
        try {
            Any delerePropertiesAny;
            this._repoConn.setAutoCommit(false);
            this._addStmts = new ArrayList<Statement>();
            this._clearStmts = new ArrayList<Statement>();
            ArrayList<String> clearedProperties = new ArrayList<String>();
            Collection<String> reversedProperties = this.getReversedProperties(record.getMetadata());
            Collection<String> objectProperties = this.getObjectProperties(record.getMetadata());
            URI uri = this.findUri(record.getMetadata(), uriAttribute);
            AnyMap metadata = record.getMetadata();
            if (metadata.containsKey((Object)"_deleteAll") && Boolean.TRUE.equals(metadata.containsKey((Object)"_deleteAll"))) {
                this.clearResource(uri);
                commit = true;
                URI uRI = uri;
                return uRI;
            }
            if (metadata.containsKey((Object)"_deleteProperties") && (delerePropertiesAny = (Any)metadata.get((Object)"_deleteProperties")) != null) {
                for (Any valueAny : delerePropertiesAny) {
                    if (!valueAny.isString()) continue;
                    clearedProperties.add(((org.eclipse.smila.datamodel.Value)valueAny).asString());
                }
            }
            for (Map.Entry entry : metadata.entrySet()) {
                if (uriAttribute.equals(entry.getKey())) continue;
                this.createStatements(uri, (String)entry.getKey(), (Any)entry.getValue(), defaultTypeUri, clearedProperties, reversedProperties.contains(entry.getKey()), objectProperties);
            }
            if (!this._addStmts.isEmpty()) {
                for (Statement stmt : this._clearStmts) {
                    this._repoConn.remove(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), new Resource[0]);
                }
                for (Statement stmt : this._addStmts) {
                    try {
                        this._log.debug((Object)("adding stmt: " + stmt));
                        this._repoConn.add(stmt, new Resource[0]);
                    }
                    catch (Exception ex) {
                        this._log.error((Object)"failed to add a stmt", (Throwable)ex);
                    }
                }
                commit = true;
            }
            URI uRI = uri;
            return uRI;
        }
        finally {
            this._addStmts = null;
            this._clearStmts = null;
            if (commit) {
                this._repoConn.commit();
            } else {
                this._repoConn.rollback();
            }
        }
    }

    private Collection<String> getReversedProperties(AnyMap objectAsAnyMap) {
        Any reversePropertiesAny;
        ArrayList<String> reversedProperties = new ArrayList<String>();
        if (objectAsAnyMap.containsKey((Object)"_reverseProperties") && (reversePropertiesAny = (Any)objectAsAnyMap.get((Object)"_reverseProperties")) != null) {
            for (Any valueAny : reversePropertiesAny) {
                if (!valueAny.isString()) continue;
                reversedProperties.add(((org.eclipse.smila.datamodel.Value)valueAny).asString());
            }
        }
        return reversedProperties;
    }

    private Collection<String> getObjectProperties(AnyMap objectAsAnyMap) {
        Any objectPropertiesAny;
        Collection<String> objectProperties = this.getReversedProperties(objectAsAnyMap);
        if (objectAsAnyMap.containsKey((Object)"_objectProperties") && (objectPropertiesAny = (Any)objectAsAnyMap.get((Object)"_objectProperties")) != null) {
            for (Any valueAny : objectPropertiesAny) {
                if (!valueAny.isString()) continue;
                objectProperties.add(((org.eclipse.smila.datamodel.Value)valueAny).asString());
            }
        }
        return objectProperties;
    }

    private void clearResource(URI uri) throws RepositoryException {
        this._repoConn.remove(null, null, (Value)uri, new Resource[0]);
        this._repoConn.remove((Resource)uri, null, null, new Resource[0]);
    }

    private void createStatements(URI uri, String attributeName, Any attribute, String defaultTypeUri, Collection<String> deletedProperties, boolean isReverse, Collection<String> objectProperties) throws RepositoryException {
        if (attributeName == null || attributeName.startsWith("_")) {
            return;
        }
        if (attribute.isMap() && ((AnyMap)attribute).containsKey((Object)"rdf:about")) {
            AnyMap subObject = (AnyMap)attribute;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("recursive sub object found for attribute '" + attributeName + "' : " + attribute));
            }
            Collection<String> reversedProperties = this.getReversedProperties(subObject);
            Collection<String> subObjectProperties = this.getObjectProperties(subObject);
            URI uRI = this.findUri(subObject, "rdf:about");
            for (Map.Entry entry : subObject.entrySet()) {
                if (!"rdf:about".equals(entry.getKey())) {
                    this.createStatements(uRI, (String)entry.getKey(), (Any)entry.getValue(), defaultTypeUri, null, reversedProperties.contains(entry.getKey()), subObjectProperties);
                    continue;
                }
                HashSet<String> newObjectReferences = new HashSet<String>(objectProperties);
                newObjectReferences.add(attributeName);
                this.createStatements(uri, attributeName, (Any)entry.getValue(), defaultTypeUri, deletedProperties, isReverse, newObjectReferences);
            }
        } else if (attribute.isSeq()) {
            Iterator iter = attribute.iterator();
            while (iter.hasNext()) {
                this.createStatements(uri, attributeName, (Any)iter.next(), defaultTypeUri, deletedProperties, isReverse, objectProperties);
            }
        } else {
            URI predicate = this._valueHelper.createUri(this._repoConn, attributeName);
            boolean haveTypeStatement = false;
            if (deletedProperties != null && deletedProperties.contains(attributeName)) {
                this.addClearStatement((Resource)uri, predicate, isReverse);
            }
            ArrayList<Object> rdfValues = new ArrayList<Object>();
            if (attribute.isMap()) {
                for (Map.Entry entry : ((AnyMap)attribute).entrySet()) {
                    rdfValues.add(this._valueHelper.createLiteral(this._repoConn, (org.eclipse.smila.datamodel.Value)entry.getValue(), (String)entry.getKey()));
                }
            } else {
                Any any = attribute;
                if (RDF.TYPE.equals((Object)predicate)) {
                    rdfValues.add(this._valueHelper.createUri(this._repoConn, ((org.eclipse.smila.datamodel.Value)any).asString()));
                    haveTypeStatement = true;
                } else if (objectProperties.contains(attributeName)) {
                    rdfValues.add(this._valueHelper.createUri(this._repoConn, ((org.eclipse.smila.datamodel.Value)any).asString()));
                } else {
                    rdfValues.add(this._valueHelper.createLiteral(this._repoConn, (org.eclipse.smila.datamodel.Value)any, null));
                }
            }
            for (Value value : rdfValues) {
                if (isReverse && value instanceof URI) {
                    this._addStmts.add(this._repoConn.getValueFactory().createStatement((Resource)((URI)value), predicate, (Value)uri));
                    continue;
                }
                this._addStmts.add(this._repoConn.getValueFactory().createStatement((Resource)uri, predicate, value));
            }
            if (!haveTypeStatement && defaultTypeUri != null) {
                URI uRI = this._valueHelper.createUri(this._repoConn, defaultTypeUri);
                this._addStmts.add(this._repoConn.getValueFactory().createStatement((Resource)uri, RDF.TYPE, (Value)uRI));
            }
        }
    }

    private void addClearStatement(Resource uri, URI predicate, boolean isReverse) {
        if (isReverse) {
            this._clearStmts.add(this._repoConn.getValueFactory().createStatement(null, predicate, (Value)uri));
        } else {
            this._clearStmts.add(this._repoConn.getValueFactory().createStatement(uri, predicate, null));
        }
    }

    private URI findUri(AnyMap metadata, String uriAttribute) throws RepositoryException {
        String uriLiteral;
        URI uri = null;
        if (metadata.containsKey((Object)uriAttribute) && (uriLiteral = metadata.getStringValue(uriAttribute)) != null) {
            uri = this._valueHelper.createUri(this._repoConn, uriLiteral);
        }
        if (uri == null) {
            throw new RepositoryException("did not find a resource URI for record.");
        }
        return uri;
    }
}

