/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.api.helper.ResultBuilder;
import org.eclipse.smila.solr.Activator;
import org.eclipse.smila.solr.admin.SolrAdministration;

public class SolrResultBuilder
extends ResultBuilder {
    private static final String DEFAULT_WORKFLOW = "SolrSearchDefaultWorkflow";
    protected final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final QueryResponse _response;

    public SolrResultBuilder(Record record, QueryResponse response) {
        super(DEFAULT_WORKFLOW, record);
        this._response = response;
    }

    public SolrResultBuilder(String workflowName, Record record, QueryResponse response) {
        super(workflowName, record);
        this._response = response;
    }

    public Record processResponse() {
        this.setRuntime(new Long(this._response.getQTime()));
        this.processQueryResponse();
        this.processFacetResponse();
        this.processTermsResponse();
        this.processSpellcheckResponse();
        this.processMoreLikeThis();
        this.processGroupResponse();
        return this.getResult();
    }

    private void processMoreLikeThis() {
        Object mltResults = this._response.getResponse().get("moreLikeThis");
    }

    private void processQueryResponse() {
        SolrDocumentList results = this._response.getResults();
        if (results == null) {
            return;
        }
        SimpleOrderedMap<SolrDocumentList> moreLikeThisLists = this.getMoreLikeThisLists();
        Map highlighting = this._response.getHighlighting();
        this.setCount(results.getNumFound());
        this.setMaxScore(results.getMaxScore());
        int index = 0;
        for (SolrDocument document : results) {
            AnyMap item = this.convertSolrDocToSmilaResultItemStub(document);
            this.getResultRecords().add((Object)item);
            this.addResultFieldsToItem(item, document);
            this.processHighlightingResponse(highlighting, item);
            if (moreLikeThisLists != null) {
                SolrDocumentList relatedDocs = (SolrDocumentList)moreLikeThisLists.getVal(index);
                this.addMoreLikeThisToItem(item, relatedDocs);
            }
            ++index;
        }
    }

    private SimpleOrderedMap<SolrDocumentList> getMoreLikeThisLists() {
        Object mltObject = this._response.getResponse().get("moreLikeThis");
        if (mltObject != null) {
            if (mltObject instanceof SimpleOrderedMap) {
                return (SimpleOrderedMap)mltObject;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)String.format("object %s is not a SimpleOrderedMap but of type %s", "moreLikeThis", mltObject.getClass()));
            }
        } else if (this._log.isDebugEnabled()) {
            this._log.debug((Object)String.format("object %s does not exist in response", "moreLikeThis"));
        }
        return null;
    }

    private AnyMap convertSolrDocToSmilaResultItemStub(SolrDocument document) {
        Double score;
        String id;
        block2: {
            id = (String)document.getFieldValue("_recordid");
            score = -1.0;
            Object scoreObj = document.getFieldValue("score");
            try {
                Number scoreNumber = (Number)scoreObj;
                score = scoreNumber.doubleValue();
            }
            catch (Exception e) {
                if (!this._log.isWarnEnabled()) break block2;
                String msg = e instanceof NullPointerException ? "No score value in the solr result for id: " + id : (e instanceof ClassCastException ? MessageFormat.format("The score value returned from solr is not a Number for id: {0} -> score as string: {1}", id, scoreObj) : "Cannot get score for id: " + id);
                this._log.warn((Object)(String.valueOf(msg) + ". Setting score to -1. Check your config to fix this."));
            }
        }
        AnyMap resultItem = this.getResultRecords().getFactory().createAnyMap();
        resultItem.put("_recordid", id);
        resultItem.put("_weight", (Number)score);
        return resultItem;
    }

    private void addMoreLikeThisToItem(AnyMap item, SolrDocumentList relatedDocs) {
        AnyMap map = item.getMap("_mlt.meta", true);
        map.put("start", (Number)relatedDocs.getStart());
        map.put("count", (Number)relatedDocs.getNumFound());
        map.put("max_score", (Number)relatedDocs.getMaxScore());
        AnySeq mltSeq = item.getSeq("_mlt", true);
        for (SolrDocument solrMltDoc : relatedDocs) {
            AnyMap mltSmilaItem = this.convertSolrDocToSmilaResultItemStub(solrMltDoc);
            this.addResultFieldsToItem(mltSmilaItem, solrMltDoc);
            mltSeq.add((Object)mltSmilaItem);
        }
    }

    private void addResultFieldsToItem(AnyMap item, SolrDocument document) {
        for (Map.Entry entry : document.entrySet()) {
            try {
                Object value;
                String key = (String)entry.getKey();
                if (key.equals("_recordid") || key.equals("score") || (value = entry.getValue()) == null) continue;
                if (value instanceof Collection) {
                    this.addMultiKeyValuePairToItem(key, value, item);
                    continue;
                }
                this.addSingleKeyValuePairToItem(key, value, item);
            }
            catch (Exception exception) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)("Error adding solr result to record item for field name: " + (String)entry.getKey() + ". this field has been skipped."), (Throwable)exception);
            }
        }
    }

    private void addSingleKeyValuePairToItem(String key, Object value, AnyMap item) {
        DataFactory factory = item.getFactory();
        Value autoConvertValue = factory.autoConvertValue(value);
        item.put(key, (Any)autoConvertValue);
    }

    private void addMultiKeyValuePairToItem(String key, Object value, AnyMap item) {
        DataFactory factory = item.getFactory();
        Collection multiValues = (Collection)value;
        AnySeq seq = factory.createAnySeq();
        item.put(key, (Any)seq);
        for (Object multiValue : multiValues) {
            Value autoConvertValue = factory.autoConvertValue(multiValue);
            seq.add((Object)autoConvertValue);
        }
    }

    private void processFacetResponse() {
        if (this._response.getFacetFields() != null) {
            for (FacetField facet : this._response.getFacetFields()) {
                this.addFacetFieldToRecord(facet);
            }
        }
        if (this._response.getFacetDates() != null) {
            for (FacetField facet : this._response.getFacetDates()) {
                this.addFacetFieldToRecord(facet);
            }
        }
        if (this._response.getFacetQuery() != null) {
            HashMap facets = new HashMap();
            for (Map.Entry entry : this._response.getFacetQuery().entrySet()) {
                String facetName = StringUtils.substringBeforeLast((String)((String)entry.getKey()), (String)"_");
                AnySeq facet = (AnySeq)facets.get(facetName);
                if (facet == null) {
                    facet = this.addFacet(facetName);
                }
                this.addFacetValue(facet, entry.getKey(), ((Integer)entry.getValue()).longValue());
            }
        }
    }

    private void addFacetFieldToRecord(FacetField facet) {
        List values = facet.getValues();
        if (values == null || values.size() < 1) {
            return;
        }
        AnySeq facetSeq = this.addFacet(facet.getName());
        Any.ValueType valueType = this.getFacetValueType(facet);
        for (FacetField.Count count : values) {
            this.addFacetValue(facetSeq, count.getName(), valueType, count.getCount());
        }
        facetSeq.add((Number)facet.getValueCount());
    }

    private Any.ValueType getFacetValueType(FacetField facet) {
        String indexName = this.getResult().getMetadata().getStringValue("indexname");
        try {
            SolrAdministration administration = Activator.getInstance().getSolrManager().getSolrAdministration();
            Map<String, Any.ValueType> fieldNamesAndTypes = administration.getFieldNamesAndTypes(indexName);
            if (fieldNamesAndTypes != null && fieldNamesAndTypes.containsKey(facet.getName())) {
                return fieldNamesAndTypes.get(facet.getName());
            }
        }
        catch (Exception exception) {
            this._log.warn((Object)"Can't get field names and type from solr administration. Use default ValueType for all facets.", (Throwable)exception);
        }
        return Any.ValueType.STRING;
    }

    private void processTermsResponse() {
        NamedList terms = (NamedList)this._response.getResponse().get("terms");
        if (terms == null) {
            return;
        }
        AnyMap map = this.getTermsMap(true);
        DataFactory factory = map.getFactory();
        int i = 0;
        while (i < terms.size()) {
            NamedList field = (NamedList)terms.getVal(i);
            int z = 0;
            while (z < field.size()) {
                String name = field.getName(z);
                Object value = field.getVal(z);
                Value autoConvertValue = factory.autoConvertValue(value);
                map.put(name, (Any)autoConvertValue);
                ++z;
            }
            ++i;
        }
    }

    private void processSpellcheckResponse() {
        SpellCheckResponse spellcheck = this._response.getSpellCheckResponse();
        if (spellcheck == null) {
            return;
        }
        Map suggestions = spellcheck.getSuggestionMap();
        if (suggestions != null && suggestions.size() > 0) {
            List solrCollations;
            AnyMap smilaSpellResults = this.getSpellcheckMap(true);
            AnyMap smilaMispellingsMap = smilaSpellResults.getMap("suggestions", true);
            for (Map.Entry entry : suggestions.entrySet()) {
                SpellCheckResponse.Suggestion suggestion = (SpellCheckResponse.Suggestion)entry.getValue();
                if (suggestion == null) continue;
                AnyMap smilaSpellResult = smilaMispellingsMap.getMap((String)entry.getKey(), true);
                smilaSpellResult.put("numFound", (Number)suggestion.getNumFound());
                smilaSpellResult.put("startOffset", (Number)suggestion.getStartOffset());
                smilaSpellResult.put("endOffset", (Number)suggestion.getEndOffset());
                smilaSpellResult.put("origFreq", (Number)suggestion.getOriginalFrequency());
                AnyMap resultSuggestions = smilaSpellResult.getMap("suggestions", true);
                List alternatives = suggestion.getAlternatives();
                List alternativeFrequencies = suggestion.getAlternativeFrequencies();
                int i = 0;
                while (i < suggestion.getNumFound()) {
                    AnyMap resultSuggestion = resultSuggestions.getMap((String)alternatives.get(i), true);
                    if (alternativeFrequencies != null) {
                        resultSuggestion.put("freq", (Number)alternativeFrequencies.get(i));
                    }
                    ++i;
                }
            }
            String collationString = spellcheck.getCollatedResult();
            if (collationString != null) {
                smilaSpellResults.put("collation", collationString);
            }
            if ((solrCollations = spellcheck.getCollatedResults()) != null) {
                AnySeq smilaCollationResult = smilaSpellResults.getSeq("collations", true);
                for (SpellCheckResponse.Collation solrCollation : solrCollations) {
                    AnyMap smilaCollation = smilaCollationResult.getFactory().createAnyMap();
                    smilaCollation.put("collationQueryString", solrCollation.getCollationQueryString());
                    List solrCorrections = solrCollation.getMisspellingsAndCorrections();
                    if (solrCorrections != null) {
                        AnySeq smilaCorrections = smilaCollation.getSeq("misspellingsAndCorrections", true);
                        for (SpellCheckResponse.Correction solrCorrection : solrCorrections) {
                            AnyMap smilaCorrection = smilaCorrections.getFactory().createAnyMap();
                            smilaCorrection.put("correction", solrCorrection.getCorrection());
                            smilaCorrection.put("original", solrCorrection.getOriginal());
                            smilaCollation.put("misspellingsAndCorrections", (Any)smilaCorrection);
                        }
                    }
                    smilaCollation.put("numberOfHits", (Number)solrCollation.getNumberOfHits());
                    smilaCollationResult.add((Object)smilaCollation);
                }
                smilaSpellResults.put("collations", (Any)smilaCollationResult);
            }
        }
    }

    AnyMap getSolrResultMap(Boolean create) {
        return this.getResult().getMetadata().getMap("_solr.result", create.booleanValue());
    }

    private AnyMap getTermsMap(Boolean create) {
        return this.getSolrResultMap(create).getMap("terms", create.booleanValue());
    }

    private AnyMap getSpellcheckMap(Boolean create) {
        return this.getSolrResultMap(create).getMap("spellcheck", create.booleanValue());
    }

    private void setMaxScore(Number maxScore) {
        if (maxScore != null) {
            this.getSolrResultMap(true).put("max_score", maxScore);
        }
    }

    private void processGroupResponse() {
        GroupResponse groupResponse = this._response.getGroupResponse();
        if (groupResponse == null) {
            return;
        }
        for (GroupCommand command : groupResponse.getValues()) {
            String name = command.getName();
            AnySeq groupSeq = this.addGroup(name);
            DataFactory factory = groupSeq.getFactory();
            for (Group group : command.getValues()) {
                String value = group.getGroupValue();
                if (value == null) {
                    value = "_NULL";
                }
                SolrDocumentList docList = group.getResult();
                AnySeq results = factory.createAnySeq();
                for (SolrDocument doc : docList) {
                    AnyMap result = this.convertSolrDocToSmilaResultItemStub(doc);
                    this.addResultFieldsToItem(result, doc);
                    results.add((Object)result);
                }
                Long count = docList.getNumFound();
                this.addGroupResults(groupSeq, (Any)factory.autoConvertValue((Object)value), count, results);
            }
        }
    }

    private void processHighlightingResponse(Map<String, Map<String, List<String>>> highlighting, AnyMap resultItem) {
        if (highlighting == null) {
            return;
        }
        String recordid = resultItem.getStringValue("_recordid");
        for (Map.Entry<String, List<String>> entry : highlighting.get(recordid).entrySet()) {
            String attribute = entry.getKey();
            List<String> text = entry.getValue();
            if (text.size() > 1) {
                this.addHighlightText(resultItem, attribute, text);
                continue;
            }
            this.addHighlightText(resultItem, attribute, text.get(0));
        }
    }
}

