/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class Overlay {
    private Shell baseShell;
    private Shell overlayShell;
    private Color blue;
    private int offsetX;
    private int offsetY;
    List<Adornment> adornments = new ArrayList<Adornment>();

    public void addAdornment(Adornment a) {
        this.adornments.add(a);
        this.updateRegion();
        this.overlayShell.redraw();
    }

    public void addOutline(Rectangle rect, int width) {
        rect.x += this.offsetX;
        rect.y += this.offsetY;
        this.addAdornment(new OutlineRegion(rect, width));
    }

    public void removeAdornment(Adornment a) {
        this.adornments.remove(a);
        if (this.adornments.size() == 0) {
            this.overlayShell.setVisible(false);
        } else {
            this.overlayShell.redraw();
        }
    }

    public void clear() {
        this.adornments.clear();
        this.overlayShell.setVisible(false);
    }

    public Overlay(Shell shell) {
        this.baseShell = shell;
        Rectangle cr = this.baseShell.getClientArea();
        Rectangle trim = this.baseShell.computeTrim(cr.x, cr.y, cr.width, cr.height);
        this.offsetX = -trim.x;
        this.offsetY = -trim.y;
        this.overlayShell = new Shell(this.baseShell, 16392);
        this.overlayShell.setBounds(this.baseShell.getBounds());
        this.overlayShell.setBackground(this.baseShell.getDisplay().getSystemColor(6));
        this.overlayShell.setAlpha(128);
        this.blue = new Color((Device)this.baseShell.getDisplay(), 0, 0, 128);
        this.overlayShell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(Overlay.this.blue);
                e.gc.setBackground(Overlay.this.blue);
                for (Adornment adornment : Overlay.this.adornments) {
                    adornment.drawAdornment(e.gc);
                }
            }
        });
    }

    private void updateRegion() {
        Region region = new Region();
        for (Adornment adornment : this.adornments) {
            adornment.updateRegion(region);
        }
        this.overlayShell.setRegion(region);
        if (!this.overlayShell.getVisible()) {
            this.overlayShell.setVisible(true);
        }
    }

    public void dispose() {
        this.adornments.clear();
        if (!this.overlayShell.isDisposed()) {
            this.overlayShell.dispose();
        }
    }

    public class ActiveRegion
    extends Adornment {
        Label label;
        Listener activeListener;

        public ActiveRegion(Rectangle rect, Listener listener) {
            this.label = new Label((Composite)Overlay.this.overlayShell, 0);
            this.label.setBounds(rect);
        }

        public void updateRegion(Region region) {
            region.add(this.label.getBounds());
        }

        public void drawAdornment(GC gc) {
        }
    }

    public abstract class Adornment {
        public abstract void updateRegion(Region var1);

        public abstract void drawAdornment(GC var1);
    }

    public class OutlineRegion
    extends Adornment {
        Rectangle innerRect;
        Rectangle outerRect;
        int width;

        public OutlineRegion(Rectangle rect, int width) {
            this.innerRect = rect;
            this.width = width;
        }

        public void updateRegion(Region region) {
            this.outerRect = new Rectangle(this.innerRect.x - this.width, this.innerRect.y - this.width, this.innerRect.width + 2 * this.width, this.innerRect.height + 2 * this.width);
            region.add(this.outerRect);
            region.subtract(this.innerRect);
        }

        public void drawAdornment(GC gc) {
            gc.fillRectangle(this.outerRect);
        }
    }
}

