/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.state.objectstore;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.importing.state.objectstore.ObjectStoreStateService;
import org.eclipse.smila.importing.state.objectstore.StateException;
import org.eclipse.smila.importing.state.objectstore.StateStoreConfiguration;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class ObjectStoreDeltaService
implements DeltaService {
    public static final String BUNDLE_ID = "org.eclipse.smila.importing.state.objectstore";
    public static final String STORENAME = "deltaservice";
    private final Log _log = LogFactory.getLog(this.getClass());
    private ObjectStoreStateService _stateService;
    private ObjectStoreService _objectStore;

    protected void activate(ComponentContext context) {
        Properties props;
        try {
            props = ConfigUtils.getConfigProperties((String)BUNDLE_ID, (String)"deltastore.properties");
        }
        catch (Exception exception) {
            this._log.info((Object)"No configuration org.eclipse.smila.importing.state.objectstore/ found, using default settings.");
            props = new Properties();
        }
        StateStoreConfiguration configuration = new StateStoreConfiguration(props);
        this._stateService = new ObjectStoreStateService(STORENAME, configuration, this._objectStore);
    }

    protected void deactivate(ComponentContext context) {
        this._stateService = null;
    }

    public State checkState(String sourceId, String recordId, String jobRunId, String hashCode) throws DeltaException {
        return this.checkState(sourceId, recordId, null, jobRunId, hashCode);
    }

    public State checkState(String sourceId, String recordId, String compoundRecordId, String jobRunId, String hashCode) throws DeltaException {
        try {
            AnyMap entry = this._stateService.getEntry(sourceId, recordId, compoundRecordId);
            if (entry == null) {
                return State.NEW;
            }
            String entryHash = entry.getStringValue("descriptor");
            if (hashCode.equals(entryHash)) {
                String entryJobRunId = entry.getStringValue("jobRunId");
                if (!jobRunId.equals(entryJobRunId)) {
                    entry.put("jobRunId", jobRunId);
                    this._stateService.writeEntry(entry);
                }
                return State.UPTODATE;
            }
            return State.CHANGED;
        }
        catch (StateException ex) {
            throw new DeltaException("Error checking state for recordId '" + recordId + "'", (Throwable)((Object)ex));
        }
    }

    public void markCompoundElementsVisited(String sourceId, String compoundRecordId, String jobRunId) throws DeltaException {
        try {
            this._stateService.markCompoundElementsVisited(sourceId, compoundRecordId, jobRunId);
        }
        catch (StateException ex) {
            throw new DeltaException("Error marking entries for compound '" + compoundRecordId + "' as visited.", (Throwable)((Object)ex));
        }
    }

    public void markAsUpdated(String sourceId, String recordId, String jobRunId, String hashCode) throws DeltaException {
        this.markAsUpdated(sourceId, recordId, null, jobRunId, hashCode);
    }

    public void markAsUpdated(String sourceId, String recordId, String compoundRecordId, String jobRunId, String hashCode) throws DeltaException {
        try {
            this._stateService.mark(sourceId, recordId, compoundRecordId, jobRunId, hashCode);
        }
        catch (StateException ex) {
            throw new DeltaException("Error marking recordId '" + recordId + "' as updated", (Throwable)((Object)ex));
        }
    }

    public void clearSource(String sourceId) throws DeltaException {
        try {
            this._stateService.clearSource(sourceId);
        }
        catch (StateException ex) {
            throw new DeltaException("Error removing all entries for source " + sourceId, (Throwable)((Object)ex));
        }
    }

    public void clearAll() throws DeltaException {
        try {
            this._stateService.clearAll();
        }
        catch (StateException ex) {
            throw new DeltaException("Error clearing all entries of all sources", (Throwable)((Object)ex));
        }
    }

    public Collection<String> getSourceIds() throws DeltaException {
        try {
            return this._stateService.getSourceIds();
        }
        catch (StateException ex) {
            throw new DeltaException("Error determining existing sources.", (Throwable)((Object)ex));
        }
    }

    public long countEntries(String sourceId, boolean countExact) throws DeltaException {
        try {
            return this._stateService.countEntries(sourceId, countExact);
        }
        catch (StateException ex) {
            throw new DeltaException("Error counting entries for source " + sourceId, (Throwable)((Object)ex));
        }
    }

    public Collection<String> getShardPrefixes(String sourceId) throws DeltaException {
        try {
            return this._stateService.getShardPrefixes(sourceId);
        }
        catch (StateException ex) {
            throw new DeltaException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    public Collection<DeltaService.EntryId> getUnvisitedEntries(String sourceAndShardPrefix, String jobRunId) throws DeltaException {
        try {
            return this._stateService.getUnvisitedObjectIds(sourceAndShardPrefix, jobRunId);
        }
        catch (StateException ex) {
            throw new DeltaException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    public void deleteEntry(String sourceId, DeltaService.EntryId entryId) throws DeltaException {
        try {
            this._stateService.deleteEntry(sourceId, entryId);
        }
        catch (StateException ex) {
            throw new DeltaException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    public void setObjectStore(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStore(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }
}

