/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client;

public class ResourceHelper {
    private static final String DEFAULT_ROOT = "/smila/";
    private static final String PIPELETS = "pipelets/";
    private static final String PIPELINES = "pipeline/";
    private static final String JOB_MANAGER_BASE = "jobmanager/";
    private static final String DATA_OBJECT_TYPES = "dataobjecttypes/";
    private static final String BUCKETS = "buckets/";
    private static final String WORKERS = "workers/";
    private static final String WORKFLOWS = "workflows/";
    private static final String JOBS = "jobs/";
    private static final String FINISH = "finish/";
    private static final String CANCEL = "cancel/";
    private static final String JOB = "job/";
    private static final String RECORD = "record/";
    private static final String BULK = "bulk/";
    private static final String TASKS = "tasks/";
    private static final String INPROGRESS = "inprogress";
    private static final String TODO = "todo";
    private static final String IMPORTING = "importing/";
    private static final String DELTA = "delta/";
    private static final String VISITED_LINKS = "visitedlinks/";
    private static final String STORE = "store/";
    private final String _rootContextResource;

    public ResourceHelper() {
        this(DEFAULT_ROOT);
    }

    public ResourceHelper(String rootContextResource) {
        String tmp = rootContextResource;
        if (!tmp.startsWith("/")) {
            tmp = "/" + tmp;
        }
        if (!tmp.endsWith("/")) {
            tmp = String.valueOf(tmp) + "/";
        }
        this._rootContextResource = tmp;
    }

    public String getPipeletsRersource() {
        return String.valueOf(this._rootContextResource) + PIPELETS;
    }

    public String getPipeletResource(String pipeletClassName) {
        return String.valueOf(this.getPipeletsRersource()) + pipeletClassName + "/";
    }

    public String getPipelinesResource() {
        return String.valueOf(this._rootContextResource) + PIPELINES;
    }

    public String getPipelineResource(String pipelineName) {
        return String.valueOf(this.getPipelinesResource()) + pipelineName + "/";
    }

    public String getJobManagerResource() {
        return String.valueOf(this._rootContextResource) + JOB_MANAGER_BASE;
    }

    public String getDataObjectTypesResource() {
        return String.valueOf(this.getJobManagerResource()) + DATA_OBJECT_TYPES;
    }

    public String getDataObjectTypeResource(String dataObjectTypeName) {
        return String.valueOf(this.getDataObjectTypesResource()) + dataObjectTypeName + "/";
    }

    public String getBucketsResource() {
        return String.valueOf(this.getJobManagerResource()) + BUCKETS;
    }

    public String getBucketResource(String bucketName) {
        return String.valueOf(this.getBucketsResource()) + bucketName + "/";
    }

    public String getWorkersResource() {
        return String.valueOf(this.getJobManagerResource()) + WORKERS;
    }

    public String getWorkerResource(String workerName) {
        return String.valueOf(this.getWorkersResource()) + workerName + "/";
    }

    public String getWorkflowsResource() {
        return String.valueOf(this.getJobManagerResource()) + WORKFLOWS;
    }

    public String getWorkflowResource(String workflowName) {
        return String.valueOf(this.getWorkflowsResource()) + workflowName + "/";
    }

    public String getJobsResource() {
        return String.valueOf(this.getJobManagerResource()) + JOBS;
    }

    public String getJobResource(String jobName) {
        return String.valueOf(this.getJobsResource()) + jobName + "/";
    }

    public String getJobRunResource(String jobName, String jobRunId) {
        return String.valueOf(this.getJobResource(jobName)) + jobRunId + "/";
    }

    public String getJobRunFinishResource(String jobName, String jobRunId) {
        return String.valueOf(this.getJobRunResource(jobName, jobRunId)) + FINISH;
    }

    public String getJobRunCancelResource(String jobName, String jobRunId) {
        return String.valueOf(this.getJobRunResource(jobName, jobRunId)) + CANCEL;
    }

    public String getPushToJobBaseResource(String jobName) {
        return String.valueOf(this._rootContextResource) + JOB + jobName + "/";
    }

    public String getPushRecordToJobResource(String jobName) {
        return String.valueOf(this.getPushToJobBaseResource(jobName)) + RECORD;
    }

    public String getPushBulkToJobResource(String jobName) {
        return String.valueOf(this.getPushToJobBaseResource(jobName)) + BULK;
    }

    public String getTasksResource() {
        return String.valueOf(this._rootContextResource) + TASKS;
    }

    public String getTasksForWorkerResource(String workerName, String taskType) {
        return String.valueOf(this.getTasksResource()) + workerName + "/" + taskType + "/";
    }

    public String getTasksInProgressForWorkerResource(String workerName) {
        return this.getTasksForWorkerResource(workerName, INPROGRESS);
    }

    public String getTasksToDoForWorkerResource(String workerName) {
        return this.getTasksForWorkerResource(workerName, TODO);
    }

    public String getTaskInProgressResource(String workerName, String taskName) {
        return String.valueOf(this.getTasksForWorkerResource(workerName, INPROGRESS)) + taskName + "/";
    }

    public String getTaskToDoResource(String workerName, String taskName) {
        return String.valueOf(this.getTasksForWorkerResource(workerName, TODO)) + taskName + "/";
    }

    public String getImportingResource() {
        return String.valueOf(this._rootContextResource) + IMPORTING;
    }

    public String getDeltaServicesResource() {
        return String.valueOf(this.getImportingResource()) + DELTA;
    }

    public String getDeltaServiceResource(String sourceName) {
        return String.valueOf(this.getDeltaServicesResource()) + sourceName + "/";
    }

    public String getVisitedLinksResource() {
        return String.valueOf(this.getImportingResource()) + VISITED_LINKS;
    }

    public String getVisitedLinksResource(String sourceName) {
        return String.valueOf(this.getVisitedLinksResource()) + sourceName + "/";
    }

    public String getStoresResource() {
        return String.valueOf(this._rootContextResource) + STORE;
    }

    public String getStoreResource(String storeName) {
        return String.valueOf(this.getStoresResource()) + storeName + "/";
    }

    public String getStoreObjectResource(String storeName, String objectId) {
        return String.valueOf(this.getStoreResource(storeName)) + objectId + "/";
    }
}

