/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.output;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.io.IODataObject;
import org.eclipse.smila.taskworker.io.IODataObjects;
import org.eclipse.smila.taskworker.output.Output;
import org.eclipse.smila.taskworker.output.OutputMode;
import org.eclipse.smila.taskworker.output.RecordOutput;
import org.eclipse.smila.taskworker.output.StreamOutput;
import org.eclipse.smila.taskworker.util.Counters;

public class Outputs
extends IODataObjects {
    private long _durationCommit;
    private Map<String, Collection<OutputMode>> _slotOutputModes = new HashMap<String, Collection<OutputMode>>(0);

    public Outputs(Map<String, List<BulkInfo>> dataObjects, ObjectStoreService objectStore) {
        super(dataObjects, objectStore);
    }

    public void setOutputModes(Map<String, Collection<OutputMode>> outputModes) {
        this._slotOutputModes = outputModes;
    }

    public <T extends Output> T getAsOutput(String slotName, Class<T> inputClass) {
        return this.getAsOutput(slotName, 0, inputClass);
    }

    public <T extends Output> T getAsOutput(String slotName, int index, Class<T> outputClass) {
        if (this.canCreate(slotName, index)) {
            BulkInfo dataObject = this.getDataObject(slotName, index);
            try {
                Constructor<T> outputConstructor = outputClass.getConstructor(BulkInfo.class, ObjectStoreService.class);
                Output output = (Output)outputConstructor.newInstance(dataObject, this.getObjectStore());
                this.putIOData(slotName, index, output);
                return (T)output;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Canot create instance of class " + outputClass, ex);
            }
        }
        return null;
    }

    public StreamOutput getAsStreamOutput(String slotName, int index) {
        return this.getAsOutput(slotName, index, StreamOutput.class);
    }

    public StreamOutput getAsStreamOutput(String slotName) {
        return this.getAsStreamOutput(slotName, 0);
    }

    public RecordOutput getAsRecordOutput(String slotName, int index) {
        return this.getAsOutput(slotName, index, RecordOutput.class);
    }

    public RecordOutput getAsRecordOutput(String slotName) {
        return this.getAsRecordOutput(slotName, 0);
    }

    public void commitAll() throws ObjectStoreException, IOException {
        for (List<IODataObject> outputs : this.getIOData().values()) {
            for (IODataObject output : outputs) {
                if (output == null) continue;
                long startTime = System.nanoTime();
                ((Output)output).commit();
                this._durationCommit += System.nanoTime() - startTime;
            }
        }
    }

    public void abortAll() throws ObjectStoreException, IOException {
        for (List<IODataObject> outputs : this.getIOData().values()) {
            for (IODataObject output : outputs) {
                if (output == null) continue;
                long startTime = System.nanoTime();
                ((Output)output).abort();
                this._durationCommit += System.nanoTime() - startTime;
            }
        }
    }

    public void addOutputCounters(Map<String, Number> counters) {
        if (this._durationCommit > 0L) {
            Counters.addDuration(counters, "duration.iodata.close", this._durationCommit);
        }
        this.addCounters(counters, "output");
    }

    protected boolean isMultiple(String slotName) {
        return this._slotOutputModes.containsKey(slotName) && this._slotOutputModes.get(slotName).contains((Object)OutputMode.MULTIPLE);
    }

    @Override
    protected boolean canCreate(String slotName, int index) {
        if (this.isMultiple(slotName)) {
            ArrayList slot = (ArrayList)this._ioData.get(slotName);
            if (slot == null) {
                slot = new ArrayList();
                this._ioData.put(slotName, slot);
            }
            return slot.size() <= index;
        }
        return super.canCreate(slotName, index);
    }

    @Override
    public BulkInfo getDataObject(String slotName, int index) {
        if (this.isMultiple(slotName)) {
            BulkInfo template = (BulkInfo)((List)this._dataObjects.get(slotName)).get(0);
            String objectNamePrefix = template.getObjectName();
            BulkInfo result = null;
            if (index == 0) {
                result = new BulkInfo(template.getBucketName(), template.getStoreName(), String.valueOf(objectNamePrefix) + index);
            } else if (((List)this._dataObjects.get(slotName)).size() <= index) {
                result = new BulkInfo(template.getBucketName(), template.getStoreName(), String.valueOf(objectNamePrefix) + index);
                ((List)this._dataObjects.get(slotName)).add(index, result);
            } else {
                result = (BulkInfo)((List)this._dataObjects.get(slotName)).get(index);
            }
            return result;
        }
        return super.getDataObject(slotName, index);
    }
}

