/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.definitions.ParameterDefinition;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.taskworker.input.InputMode;
import org.eclipse.smila.taskworker.output.OutputMode;

public class WorkerDefinition
extends DefinitionBase {
    public static final String KEY_WORKERS = "workers";
    public static final String KEY_MODES = "modes";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_OUTPUT = "output";
    public static final String KEY_INPUT = "input";
    public static final String KEY_TYPE = "type";
    public static final String KEY_TASK_GENERATOR = "taskGenerator";
    public static final String KEY_GROUP = "group";
    private final Collection<Mode> _modes = new ArrayList<Mode>();
    private final List<ParameterDefinition> _parameters;
    private final Collection<Input> _input = new ArrayList<Input>();
    private final Collection<Output> _output = new ArrayList<Output>();
    private final String _taskGenerator;

    public WorkerDefinition(AnyMap workerAny) throws InvalidDefinitionException {
        super(workerAny);
        AnySeq outputList;
        AnySeq inputList;
        this.checkParameters((Any)workerAny.get((Object)KEY_PARAMETERS));
        this._parameters = workerAny.containsKey((Object)KEY_PARAMETERS) ? ParameterDefinition.parseParameters((AnySeq)workerAny.getSeq(KEY_PARAMETERS)) : new ArrayList<ParameterDefinition>();
        this._taskGenerator = workerAny.getStringValue(KEY_TASK_GENERATOR);
        List modeNames = AccessAny.getStringSeq((AnyMap)workerAny, (String)KEY_MODES);
        if (modeNames != null) {
            for (String modeName : modeNames) {
                try {
                    this._modes.add(Mode.valueOf(modeName.toUpperCase(Locale.US)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidDefinitionException("Invalid worker definition mode name " + modeName + " for worker " + this._name);
                }
            }
        }
        if ((inputList = (AnySeq)AccessAny.get((AnyMap)workerAny, (String)KEY_INPUT, (Any.ValueType)Any.ValueType.SEQ)) != null) {
            try {
                for (Any inputAny : inputList) {
                    this._input.add(new Input((AnyMap)inputAny));
                }
            }
            catch (Exception e) {
                throw new InvalidDefinitionException("Invalid input for worker description " + this._name, (Throwable)e);
            }
        }
        if ((outputList = (AnySeq)AccessAny.get((AnyMap)workerAny, (String)KEY_OUTPUT, (Any.ValueType)Any.ValueType.SEQ)) != null) {
            try {
                for (Any outputAny : outputList) {
                    this._output.add(new Output((AnyMap)outputAny));
                }
            }
            catch (Exception e) {
                throw new InvalidDefinitionException("Invalid output for worker description " + this._name, (Throwable)e);
            }
        }
    }

    public Collection<Mode> getModes() {
        return this._modes;
    }

    public Collection<String> getMandatoryParameterNames() {
        ArrayList<String> mandatoryParameters = new ArrayList<String>();
        if (this._parameters != null) {
            for (ParameterDefinition parameter : this._parameters) {
                if (parameter.isOptional()) continue;
                mandatoryParameters.add(parameter.getName());
            }
        }
        return mandatoryParameters;
    }

    public List<ParameterDefinition> getParameters() {
        return this._parameters;
    }

    public List<ParameterDefinition> getParametersByRange(String range) {
        ArrayList<ParameterDefinition> result = new ArrayList<ParameterDefinition>();
        for (ParameterDefinition parameterDef : this._parameters) {
            String paramRange = parameterDef.getRange();
            if ((range != null && !range.isEmpty() || paramRange != null && !paramRange.isEmpty()) && (range == null || !range.equals(paramRange))) continue;
            result.add(parameterDef);
        }
        return result;
    }

    public String getTaskGenerator() {
        return this._taskGenerator;
    }

    public Collection<Input> getInput() {
        return this._input;
    }

    public Collection<Output> getOutput() {
        return this._output;
    }

    public Map<String, Collection<OutputMode>> getOutputModes() {
        HashMap<String, Collection<OutputMode>> result = new HashMap<String, Collection<OutputMode>>();
        if (this._output != null) {
            for (Output out : this._output) {
                result.put(out.getName(), out.getModes());
            }
        }
        return result;
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap defAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                if (this._parameters != null && !this._parameters.isEmpty()) {
                    AnySeq paramSeq = ParameterDefinition.toAny(this._parameters, (boolean)includingAdditionalAttributes);
                    defAny.put(KEY_PARAMETERS, (Any)paramSeq);
                }
                if (this.getTaskGenerator() != null) {
                    defAny.put(KEY_TASK_GENERATOR, this.getTaskGenerator());
                }
                if (!this.getModes().isEmpty()) {
                    ArrayList<String> modes = new ArrayList<String>();
                    for (Mode mode : this.getModes()) {
                        modes.add(mode.toString());
                    }
                    defAny.put(KEY_MODES, AnyUtil.objectToAny(modes));
                }
                if (!this.getInput().isEmpty()) {
                    AnySeq inputAny = AccessAny.FACTORY.createAnySeq();
                    for (Input input : this.getInput()) {
                        inputAny.add((Object)input.toAny());
                    }
                    defAny.put(KEY_INPUT, (Any)inputAny);
                }
                if (!this.getOutput().isEmpty()) {
                    AnySeq outputAny = AccessAny.FACTORY.createAnySeq();
                    for (Output output : this.getOutput()) {
                        outputAny.add((Object)output.toAny());
                    }
                    defAny.put(KEY_OUTPUT, (Any)outputAny);
                }
            }
            return defAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for data object type mode", ex);
        }
    }

    public Input getInput(String slotName) {
        if (this._input != null) {
            for (Input iterableElement : this._input) {
                if (!iterableElement.getName().equals(slotName)) continue;
                return iterableElement;
            }
        }
        return null;
    }

    public Output getOutput(String slotName) {
        if (this._output != null) {
            for (Output iterableElement : this._output) {
                if (!iterableElement.getName().equals(slotName)) continue;
                return iterableElement;
            }
        }
        return null;
    }

    public boolean hasOnlyMandatoryGroups() {
        HashSet<String> mandatoryGroups = new HashSet<String>();
        HashSet<String> optionalGroups = new HashSet<String>();
        for (Output output : this._output) {
            String group = output.getGroup();
            if (group == null) continue;
            if (output.getModes().contains(OutputMode.OPTIONAL)) {
                optionalGroups.add(group);
                continue;
            }
            mandatoryGroups.add(group);
        }
        optionalGroups.removeAll(mandatoryGroups);
        return !mandatoryGroups.isEmpty() && optionalGroups.isEmpty();
    }

    private void checkParameters(Any parameters) throws InvalidDefinitionException {
        if (parameters != null) {
            if (!parameters.isSeq()) {
                throw new InvalidDefinitionException("invalid parameters format. Only Sequence of Maps allowed.");
            }
            AnySeq parameterSeq = parameters.asSeq();
            for (Any singleParam : parameterSeq) {
                if (singleParam.isMap()) {
                    Any nameOfParam = (Any)singleParam.asMap().get((Object)"name");
                    if (nameOfParam != null && nameOfParam.isString()) continue;
                    throw new InvalidDefinitionException("Parameter found without 'name' argument of type string: " + singleParam);
                }
                throw new InvalidDefinitionException("invalid parameters format. Only Sequence of Maps allowed.");
            }
        }
    }

    public static class Input
    extends InputOutput<InputMode> {
        public Input(AnyMap inputAny) throws InvalidDefinitionException {
            super(inputAny);
        }

        @Override
        protected InputMode getMode(String modeName) {
            return InputMode.valueOf((String)modeName);
        }
    }

    public static abstract class InputOutput<T extends Enum<T>> {
        private final String _name;
        private final String _type;
        private final Collection<T> _modes = new ArrayList<T>();

        public InputOutput(AnyMap any) throws InvalidDefinitionException {
            this._name = AccessAny.getStringRequired((AnyMap)any, (String)"name");
            this._type = AccessAny.getStringRequired((AnyMap)any, (String)WorkerDefinition.KEY_TYPE);
            List modeNames = AccessAny.getStringSeq((AnyMap)any, (String)WorkerDefinition.KEY_MODES);
            if (modeNames != null) {
                for (String modeName : modeNames) {
                    try {
                        this._modes.add(this.getMode(modeName.toUpperCase(Locale.US)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidDefinitionException("Invalid worker definition mode name " + modeName + " for worker " + this._name);
                    }
                }
            }
        }

        protected abstract T getMode(String var1);

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public Collection<T> getModes() {
            return this._modes;
        }

        public String toString() {
            return String.format("name: \"%s\", type: \"%s\", modes %s", this._name, this._type, this._modes);
        }

        public Any toAny() throws Exception {
            AnyMap resultAny = AccessAny.FACTORY.createAnyMap();
            resultAny.put("name", this.getName());
            resultAny.put(WorkerDefinition.KEY_TYPE, this.getType());
            if (!this.getModes().isEmpty()) {
                AnySeq modes = AccessAny.FACTORY.createAnySeq();
                for (Enum mode : this.getModes()) {
                    modes.add(mode.toString());
                }
                resultAny.put(WorkerDefinition.KEY_MODES, (Any)modes);
            }
            return resultAny;
        }
    }

    public static enum Mode {
        BULKSOURCE("bulkSource"),
        AUTOCOMMIT("autoCommit"),
        RUNALWAYS("runAlways"),
        REQUESTSCOMPLETION("requestsCompletion"),
        BARRIER("barrier");

        private String _name;

        private Mode(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }

    public static class Output
    extends InputOutput<OutputMode> {
        private final String _group;

        public Output(AnyMap outputAny) throws InvalidDefinitionException {
            super(outputAny);
            this._group = AccessAny.getString((AnyMap)outputAny, (String)WorkerDefinition.KEY_GROUP);
        }

        @Override
        protected OutputMode getMode(String modeName) {
            return OutputMode.valueOf((String)modeName);
        }

        public String getGroup() {
            return this._group;
        }

        @Override
        public Any toAny() throws Exception {
            AnyMap resultAny = (AnyMap)super.toAny();
            if (this._group != null) {
                resultAny.put(WorkerDefinition.KEY_GROUP, this._group);
            }
            return resultAny;
        }
    }
}

