/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class WorkflowRunHandler
extends AJobManagerHandler {
    private static final int URIPARTS_COUNT = 3;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() == 3) {
            String jobName = (String)uriParts.get(0);
            String jobId = (String)uriParts.get(1);
            String workflowRunId = (String)uriParts.get(2);
            return this.getJobRunDataProvider().getWorkflowRunData(jobName, jobId, workflowRunId);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'");
    }

    @Override
    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof JobManagerException) {
            return 404;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }
}

