/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.List;
import org.eclipse.smila.jobmanager.JobTaskProcessor;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.exceptions.NoSuchTaskGeneratorException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.taskworker.PostponeTaskException;
import org.eclipse.smila.taskworker.RecoverableTaskException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;

public class FinishTaskWorker
implements Worker {
    private static final String WORKER_NAME = "_finishingTasks";
    private JobTaskProcessor _jobTaskProcessor;

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        try {
            List<Task> newTasks = this.finishTask(taskContext);
            this.countNewTasks(taskContext, newTasks);
        }
        catch (JobManagerException ex) {
            if (ex.isRecoverable()) {
                throw new RecoverableTaskException(ex.getMessage(), (Throwable)((Object)ex));
            }
            throw ex;
        }
    }

    private List<Task> finishTask(TaskContext taskContext) throws JobManagerException, PostponeTaskException {
        taskContext.addToCounter("finishedTaskCount", 1L);
        long start = taskContext.getTimestamp();
        try {
            List<Task> list = this._jobTaskProcessor.finishTask(taskContext.getTask());
            return list;
        }
        catch (IllegalJobStateException e) {
            taskContext.getLog().warn(e.getMessage(), (Throwable)((Object)e));
            return null;
        }
        catch (NoSuchTaskGeneratorException e) {
            throw new PostponeTaskException("Could not find task generator. Maybe bundle has not yet been activated.", (Throwable)e);
        }
        catch (JobManagerException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof IllegalJobStateException) {
                    taskContext.getLog().warn(e.getMessage(), (Throwable)((Object)e));
                    return null;
                }
                if (e.getCause() instanceof NoSuchTaskGeneratorException) {
                    throw new PostponeTaskException("Could not find task generator. Maybe bundle has not yet been activated.", (Throwable)((Object)e));
                }
            }
            throw e;
        }
        finally {
            taskContext.measureTime("finishTask", start);
        }
    }

    private void countNewTasks(TaskContext taskContext, List<Task> newTasks) throws TaskmanagerException {
        if (newTasks != null && !newTasks.isEmpty()) {
            taskContext.addToCounter("newTaskCount", (long)newTasks.size());
        }
    }

    public void setJobTaskProcessor(JobTaskProcessor jobTaskProcessor) {
        this._jobTaskProcessor = jobTaskProcessor;
    }

    public void unsetJobTaskProcessor(JobTaskProcessor jobTaskProcessor) {
        if (this._jobTaskProcessor == jobTaskProcessor) {
            this._jobTaskProcessor = null;
        }
    }
}

