/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorBase;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;

public class CombineInputWithAllTaskGenerator
extends TaskGeneratorBase {
    public static final String PARAMETER_PARTNER_PREFIX = "_partner.";
    public static final String PARAMETER_TRIGGERED_BY = "_triggeredBy";

    @Override
    public List<Task> createTasks(Map<String, List<BulkInfo>> changedInput, Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        this.checkBucketCounts(inputBuckets, 2, outputBuckets, -1);
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Map.Entry<String, List<BulkInfo>> changedSlot : changedInput.entrySet()) {
            String changedSlotName = changedSlot.getKey();
            for (Map.Entry<String, Bucket> otherSlot : inputBuckets.entrySet()) {
                String otherSlotName = otherSlot.getKey();
                if (changedSlotName.equals(otherSlotName)) continue;
                String partnerBulkName = this.findPartnerBulk(changedInput, otherSlotName);
                Bucket partnerBucket = otherSlot.getValue();
                Collection<StoreObject> objects = this.getObjectsFromBucket(partnerBucket);
                List<BulkInfo> changedBulks = changedSlot.getValue();
                for (BulkInfo changedBulk : changedBulks) {
                    List<Task> newTasks = this.createTasksFromObjects(objects, otherSlotName, partnerBucket, changedSlotName, changedBulk, partnerBulkName, workerName);
                    this.addUniqueTasks(tasks, newTasks, parameters, outputBuckets);
                }
            }
        }
        return tasks;
    }

    private String findPartnerBulk(Map<String, List<BulkInfo>> changedInput, String slotName) {
        List<BulkInfo> bulks = changedInput.get(slotName);
        if (bulks != null && !bulks.isEmpty()) {
            return bulks.get(0).getObjectName();
        }
        return null;
    }

    protected Collection<StoreObject> getObjectsFromBucket(Bucket bucket) throws TaskGeneratorException {
        try {
            return ObjectStoreRetryUtil.retryGetStoreObjectInfos((ObjectStoreService)this._objectStore, (String)bucket.getStoreName(), (String)bucket.getDataObjectNamePrefix());
        }
        catch (Exception e) {
            throw new TaskGeneratorException(String.valueOf(e.getClass().getSimpleName()) + " during task creation: " + e.getMessage(), e);
        }
    }

    private List<Task> createTasksFromObjects(Collection<StoreObject> objects, String partnerSlotName, Bucket partnerBucket, String changedSlotName, BulkInfo changedBulk, String partnerBulkName, String workerName) {
        ArrayList<Task> tasks = new ArrayList<Task>(objects.size());
        String partnerBucketName = partnerBucket.getBucketDefinition().getName();
        String partnerStoreName = partnerBucket.getStoreName();
        String changedBulkName = changedBulk.getObjectName();
        for (StoreObject objectInfo : objects) {
            String currentObjectName = objectInfo.getId();
            BulkInfo currentObjectBulk = new BulkInfo(partnerBucketName, partnerStoreName, currentObjectName);
            AnyMap parameters = this.getTriggerInfoParameters(changedSlotName, changedBulkName, partnerSlotName, partnerBulkName, currentObjectName);
            Task task = this.createTask(workerName, parameters);
            task.getInputBulks().put(changedSlotName, Arrays.asList(changedBulk));
            task.getInputBulks().put(partnerSlotName, Arrays.asList(currentObjectBulk));
            tasks.add(task);
        }
        return tasks;
    }

    private AnyMap getTriggerInfoParameters(String changedBucketName, String changedBulkName, String partnerBucketName, String partnerBulkName, String currentObjectName) {
        AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
        if (currentObjectName.equals(partnerBulkName)) {
            parameters.put(PARAMETER_PARTNER_PREFIX + changedBucketName, changedBulkName);
            parameters.put(PARAMETER_PARTNER_PREFIX + partnerBucketName, currentObjectName);
        } else {
            parameters.put(PARAMETER_TRIGGERED_BY, changedBucketName);
            if (partnerBulkName != null) {
                parameters.put(PARAMETER_PARTNER_PREFIX + partnerBucketName, partnerBulkName);
            }
        }
        return parameters;
    }

    private void addUniqueTasks(List<Task> tasks, List<Task> newTasks, AnyMap parameters, Map<String, Bucket> outputBuckets) {
        for (Task newTask : newTasks) {
            if (this.isTaskDuplicate(tasks, newTask)) continue;
            newTask.getParameters().putAll((Map)parameters);
            this.addOutputBulks(newTask, null, outputBuckets, parameters);
            tasks.add(newTask);
        }
    }

    private boolean isTaskDuplicate(List<Task> tasks, Task newTask) {
        for (Task task : tasks) {
            if (!newTask.getInputBulks().equals(task.getInputBulks())) continue;
            return true;
        }
        return false;
    }
}

