/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.processing.bpel.WorkflowUpdateWatcher;
import org.eclipse.smila.zookeeper.ZkConcurrentMap;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class ZkUpdateWatcher
implements WorkflowUpdateWatcher {
    private static final String ROOTPATH = "/smila/processor/workflows";
    private static final int POLL_INTERVAL = 60;
    private final Log _log = LogFactory.getLog(this.getClass());
    private ZooKeeperService _zkService;
    private WorkflowProcessor _processor;
    private ZkConnection _zk;
    private ScheduledExecutorService _scheduler;
    private final Watcher _watcher = new Watcher(){

        public void process(WatchedEvent event) {
            ZkUpdateWatcher.this.watchTriggered();
        }
    };
    private boolean _watcherStarted;
    private boolean _watcherInstalled;
    private ZkConcurrentMap _clusterVersions;
    private final Map<String, Integer> _localVersions = new HashMap<String, Integer>();

    public void setZkService(ZooKeeperService zkService) {
        this._zkService = zkService;
    }

    public void unsetZkService(ZooKeeperService zkService) {
        if (this._zkService == zkService) {
            this._zkService = null;
        }
    }

    @Override
    public synchronized void registerProcessor(WorkflowProcessor processor) {
        this._processor = processor;
    }

    protected void activate() {
        try {
            this.initialize();
        }
        catch (KeeperException ex) {
            this._log.error((Object)"Failed to create znode /smila/processor/workflows, watcher service will be disfunctional.", (Throwable)ex);
        }
    }

    public void initialize() throws KeeperException {
        this._zk = new ZkConnection(this._zkService);
        this._zk.ensurePathExists(ROOTPATH);
        this._clusterVersions = new ZkConcurrentMap(this._zk, ROOTPATH);
    }

    @Override
    public synchronized boolean startWatching() {
        this._watcherStarted = true;
        this._watcherInstalled = false;
        this.installWatch();
        return this._watcherInstalled;
    }

    @Override
    public synchronized void stopWatching() {
        this._watcherStarted = false;
        this._watcherInstalled = false;
    }

    @Override
    public void startPolling() {
        this.startPolling(60);
    }

    @Override
    public synchronized void startPolling(int pollIntervalSeconds) {
        if (this._scheduler == null) {
            this._scheduler = Executors.newScheduledThreadPool(1);
            this._scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ZkUpdateWatcher.this.checkWorkflowVersions();
                    ZkUpdateWatcher.this.installWatch();
                }
            }, pollIntervalSeconds, pollIntervalSeconds, TimeUnit.SECONDS);
            this._log.info((Object)("Started: polling for workflow updates each " + pollIntervalSeconds + " seconds."));
        }
    }

    @Override
    public synchronized void stopPolling() {
        if (this._scheduler != null) {
            this._scheduler.shutdownNow();
            this._scheduler = null;
            this._log.info((Object)"Stopped.");
        }
    }

    @Override
    public synchronized void workflowLoadedOnStart(String workflowName, String timestamp) throws ProcessingException {
        try {
            this._clusterVersions.putIfAbsent(workflowName, timestamp);
            this._localVersions.put(workflowName, this._clusterVersions.getVersion(workflowName));
        }
        catch (RuntimeException runtimeException) {
            throw new ProcessingException("Failed to initialize for workflow '" + workflowName + "'.");
        }
    }

    @Override
    public synchronized void workflowUpdated(String workflowName, String timestamp) throws ProcessingException {
        try {
            Integer version;
            String oldTimestamp = this._clusterVersions.getString(workflowName);
            if (oldTimestamp == null) {
                this._clusterVersions.put(workflowName, timestamp);
                version = this._clusterVersions.getVersion(workflowName);
            } else {
                version = this._clusterVersions.replaceAndGetVersion(workflowName, oldTimestamp, timestamp);
                if (version == null) {
                    throw new ProcessingException("Failed to send update notification for workflow '" + workflowName + "'");
                }
            }
            this._localVersions.put(workflowName, version);
            this.sendNotification(String.valueOf(workflowName) + " updated at " + timestamp);
        }
        catch (RuntimeException runtimeException) {
            throw new ProcessingException("Failed to update for workflow '" + workflowName + "'.");
        }
    }

    @Override
    public synchronized void workflowDeleted(String workflowName) throws ProcessingException {
        try {
            this._clusterVersions.remove(workflowName);
            this._localVersions.remove(workflowName);
            this.sendNotification(String.valueOf(workflowName) + " deleted");
        }
        catch (RuntimeException runtimeException) {
            throw new ProcessingException("Failed to update for workflow '" + workflowName + "'.");
        }
    }

    @Override
    public synchronized void checkWorkflowVersions() {
        this._log.debug((Object)"checking versions of workflows deployed in the cluster");
        try {
            HashSet<String> obsoleteWorkflows = new HashSet<String>(this._localVersions.keySet());
            for (String workflowName : this._clusterVersions.keySet()) {
                obsoleteWorkflows.remove(workflowName);
                this.checkWorkflowVersion(workflowName);
            }
            for (String obsoleteWorkflow : obsoleteWorkflows) {
                this.deleteWorkflow(obsoleteWorkflow);
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)"Error getting cluster versions of workflows, maybe we are losing an update now. We'll retry later.", (Throwable)ex);
        }
    }

    private synchronized void checkWorkflowVersion(String workflowName) {
        try {
            Integer localVersion;
            Integer clusterVersion = this._clusterVersions.getVersion(workflowName);
            if (!(clusterVersion == null || (localVersion = this._localVersions.get(workflowName)) != null && clusterVersion.equals(localVersion))) {
                try {
                    this._processor.synchronizeWorkflowDefinition(workflowName, false);
                    this._localVersions.put(workflowName, clusterVersion);
                }
                catch (Exception ex) {
                    this._log.warn((Object)("Error updating workflow '" + workflowName + "', old version will stay active."), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error getting cluster version of workflow '" + workflowName + "', maybe we are losing an update now."), (Throwable)ex);
        }
    }

    private synchronized void deleteWorkflow(String workflowName) {
        try {
            this._processor.synchronizeWorkflowDefinition(workflowName, true);
            this._localVersions.remove(workflowName);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error deleting workflow '" + workflowName + "', old version will stay active."), (Throwable)ex);
        }
    }

    private void sendNotification(String text) {
        try {
            this._zk.setData(ROOTPATH, text.getBytes("utf-8"));
        }
        catch (Exception ex) {
            this._log.warn((Object)("Failed to update notification /smila/processor/workflows for " + text + ". Watches may not be triggered, remove workflow updates may need more time."), (Throwable)ex);
        }
    }

    private synchronized void installWatch() {
        if (this._watcherStarted && !this._watcherInstalled) {
            try {
                this._zk.exists(ROOTPATH, this._watcher);
                this._watcherInstalled = true;
            }
            catch (KeeperException ex) {
                this._log.warn((Object)"Starting to watch for updates failed, pipeline update notifications may take a bit longer: Could not install watch on znode/smila/processor/workflows", (Throwable)ex);
            }
        }
    }

    private synchronized void watchTriggered() {
        this._watcherInstalled = false;
        this.checkWorkflowVersions();
        this.installWatch();
    }
}

