/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.worker;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public abstract class ProcessingWorker
implements Worker {
    public static final String INPUT_SLOT_NAME = "input";
    public static final String OUTPUT_SLOT_NAME = "output";
    public static final String KEY_KEEPATTACHMENTSINMEMORY = "keepAttachmentsInMemory";
    public static final String KEY_WRITEATTACHMENTSTOOUTPUT = "writeAttachmentsToOutput";
    static boolean s_noBinStorageAvailableLogged;
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected BlackboardFactory _blackboardFactory;
    protected boolean _binStorageAvailable = true;

    public abstract boolean perform(AnyMap var1, RecordInput var2, RecordOutput var3, TaskContext var4) throws Exception;

    public void perform(TaskContext taskContext) throws Exception {
        AnyMap parameters = this.getTaskParameters(taskContext);
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT_NAME);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT_NAME);
        this._binStorageAvailable = true;
        boolean success = this.perform(parameters, recordInput, recordOutput, taskContext);
        if (!success) {
            throw new ProcessingException("None of the records of task " + taskContext.getTask() + " could be successfully processed, have a look at the log for details.");
        }
    }

    private AnyMap getTaskParameters(TaskContext taskContext) {
        AnyMap parameterMap = DataFactory.DEFAULT.cloneAnyMap(taskContext.getTask().getParameters());
        if (parameterMap.get((Object)"_failOnError") == null) {
            parameterMap.put("_failOnError", "false");
        }
        return parameterMap;
    }

    protected void writeResultRecords(Blackboard blackboard, String[] resultIds, RecordOutput recordOutput, TaskContext taskContext) throws ObjectStoreException, IOException {
        boolean withAttachments = this.shouldWriteAttachments(taskContext);
        if (resultIds != null && recordOutput != null) {
            String[] stringArray = resultIds;
            int n = resultIds.length;
            int n2 = 0;
            while (n2 < n) {
                String resultId = stringArray[n2];
                try {
                    Record record = blackboard.getRecordCopy(resultId, withAttachments);
                    recordOutput.writeRecord(record);
                }
                catch (BlackboardAccessException ex) {
                    taskContext.getLog().warn("Failed to read result record " + resultId + " from blackboard, skipping it.", (Throwable)ex);
                }
                ++n2;
            }
        }
    }

    protected void cleanupBlackboard(Blackboard blackboard, TaskContext taskContext) {
        try {
            blackboard.removeAll();
            blackboard.commit();
        }
        catch (BlackboardAccessException ex) {
            taskContext.getLog().warn("Error while cleaning up blackboard. Attachments may be leftover in BinaryStorage.", (Throwable)ex);
        }
    }

    private boolean shouldWriteAttachments(TaskContext taskContext) {
        Boolean writeAttachments = taskContext.getTask().getParameters().getBooleanValue(KEY_WRITEATTACHMENTSTOOUTPUT);
        return writeAttachments == null ? true : writeAttachments;
    }

    protected Blackboard getBlackboard(TaskContext taskContext) throws Exception {
        try {
            return this._blackboardFactory.createBlackboard(false, this.useBinaryStorage(taskContext));
        }
        catch (BlackboardAccessException blackboardAccessException) {
            return this.getTransientBlackboard();
        }
    }

    private Blackboard getTransientBlackboard() {
        this._binStorageAvailable = false;
        if (!s_noBinStorageAvailableLogged) {
            this._log.warn((Object)"Could not get a blackboard with binary storage, using a transient one. Attachments won't be accessible by the worker.");
            s_noBinStorageAvailableLogged = true;
        }
        return this._blackboardFactory.createTransientBlackboard();
    }

    private boolean useBinaryStorage(TaskContext taskContext) {
        if (this._binStorageAvailable) {
            try {
                Boolean keepInMemory = taskContext.getTask().getParameters().getBooleanValue(KEY_KEEPATTACHMENTSINMEMORY);
                if (keepInMemory != null) {
                    return keepInMemory == false;
                }
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
        return false;
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._blackboardFactory = null;
        }
    }
}

