/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.conversion;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeSpanParser {
    private static final List<TimeUnit> TIME_UNITS = Arrays.asList(TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS);
    private static final Pattern PATTERN = Pattern.compile("^(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s?)?$");

    private TimeSpanParser() {
    }

    public static long parse(String timeSpan, TimeUnit timeUnit, long defaultValue) {
        if (timeSpan == null || timeSpan.isEmpty()) {
            return defaultValue;
        }
        Matcher m = PATTERN.matcher(timeSpan);
        long value = 0L;
        if (m.matches()) {
            int i = 0;
            while (i < m.groupCount()) {
                if (m.group(i + 1) != null) {
                    value += TIME_UNITS.get(i).toSeconds(Long.valueOf(m.group(i + 1)));
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("'" + timeSpan + "' is not a valid timespan. It must match the pattern '" + PATTERN + "'.");
        }
        return timeUnit.convert(value, TimeUnit.SECONDS);
    }

    public static long parse(String timeSpan, TimeUnit timeUnit) {
        return TimeSpanParser.parse(timeSpan, timeUnit, 0L);
    }
}

