/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CommitProcessor.class);
    LinkedList<Request> queuedRequests = new LinkedList();
    LinkedList<Request> committedRequests = new LinkedList();
    RequestProcessor nextProcessor;
    ArrayList<Request> toProcess = new ArrayList();
    boolean matchSyncs;
    volatile boolean finished = false;

    public CommitProcessor(RequestProcessor nextProcessor, String id, boolean matchSyncs) {
        super("CommitProcessor:" + id);
        this.nextProcessor = nextProcessor;
        this.matchSyncs = matchSyncs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Request nextPending = null;
            while (!this.finished) {
                int len = this.toProcess.size();
                int i = 0;
                while (i < len) {
                    this.nextProcessor.processRequest(this.toProcess.get(i));
                    ++i;
                }
                this.toProcess.clear();
                CommitProcessor commitProcessor = this;
                synchronized (commitProcessor) {
                    if ((this.queuedRequests.size() == 0 || nextPending != null) && this.committedRequests.size() == 0) {
                        this.wait();
                        continue;
                    }
                    if ((this.queuedRequests.size() == 0 || nextPending != null) && this.committedRequests.size() > 0) {
                        Request r = this.committedRequests.remove();
                        if (nextPending != null && nextPending.sessionId == r.sessionId && nextPending.cxid == r.cxid) {
                            nextPending.hdr = r.hdr;
                            nextPending.txn = r.txn;
                            nextPending.zxid = r.zxid;
                            this.toProcess.add(nextPending);
                            nextPending = null;
                        } else {
                            this.toProcess.add(r);
                        }
                    }
                }
                if (nextPending != null) continue;
                commitProcessor = this;
                synchronized (commitProcessor) {
                    while (nextPending == null && this.queuedRequests.size() > 0) {
                        Request request = this.queuedRequests.remove();
                        switch (request.type) {
                            case -11: 
                            case -10: 
                            case 1: 
                            case 2: 
                            case 5: 
                            case 7: 
                            case 14: {
                                nextPending = request;
                                break;
                            }
                            case 9: {
                                if (this.matchSyncs) {
                                    nextPending = request;
                                    break;
                                }
                                this.toProcess.add(request);
                                break;
                            }
                            default: {
                                this.toProcess.add(request);
                            }
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted exception while waiting", (Throwable)e);
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception causing CommitProcessor to exit", e);
        }
        LOG.info("CommitProcessor exited loop!");
    }

    public synchronized void commit(Request request) {
        if (!this.finished) {
            if (request == null) {
                LOG.warn("Committed a null!", (Throwable)new Exception("committing a null! "));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Committing request:: " + request);
            }
            this.committedRequests.add(request);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void processRequest(Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing request:: " + request);
        }
        if (!this.finished) {
            this.queuedRequests.add(request);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        CommitProcessor commitProcessor = this;
        synchronized (commitProcessor) {
            this.finished = true;
            this.queuedRequests.clear();
            this.notifyAll();
        }
        if (this.nextProcessor != null) {
            this.nextProcessor.shutdown();
        }
    }
}

