/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc;

import java.io.IOException;
import org.eclipse.smila.ipc.IpcStreamWriter;

public class IpcException
extends Exception {
    private static final long serialVersionUID = 1L;

    public IpcException(String message) {
        super(message);
    }

    public IpcException(Throwable cause) {
        super(cause);
    }

    public IpcException(String message, Throwable cause) {
        super(message, cause);
    }

    public void write(IpcStreamWriter writer) throws IOException {
        IpcException.write(writer, this);
    }

    public static void write(IpcStreamWriter writer, Throwable ex) throws IOException {
        writer.writeObjectStart();
        writer.writeMappingStart();
        writer.writeMappingKey("message");
        writer.writeScalarString(IpcException.getIpcMessage(ex));
        writer.writeMappingEnd();
        writer.writeObjectEnd();
        writer.closeWithoutStream();
    }

    private static String getIpcMessage(Throwable e) {
        StringBuilder msg = new StringBuilder(IpcException.getText(e));
        while (e.getCause() != null && e.getCause() != e) {
            e = e.getCause();
            msg.append("\ncaused by: ").append(IpcException.getText(e));
        }
        return msg.toString();
    }

    private static String getText(Throwable ex) {
        if (ex.getMessage() != null) {
            return ex.getMessage();
        }
        return ex.toString();
    }
}

