/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Drazen Cindric (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.clusterconfig;

import java.util.Collection;
import java.util.List;

import org.eclipse.smila.datamodel.AnyMap;

/**
 * Interface for cluster config service.
 */
public interface ClusterConfigService {

  /** @return all configured properties as AnyMap. */
  AnyMap getAllProperties();

  /**
   * @return names of all nodes in cluster
   * @throws ClusterConfigException
   *           when not running in a configured cluster
   */
  List<String> getClusterNodes() throws ClusterConfigException;

  /**
   * @return the name of the local host
   */
  String getLocalHost();

  /**
   * @return interval for zookeeper clean up of data/log directories.
   */
  long getZkGcInterval();

  /**
   * @return number of nodes that may fail without ZooKeeper service stopping to work. '0' if no ClusterConfigService is
   *         reachable.
   */
  long getFailSafetyLevel();

  /**
   * @return true, if we are running in a configured cluster, false otherwise.
   */
  boolean isConfigured();

  /**
   * @return total max scale up for all workers of one node (checked by taskmanager).
   */
  long getMaxScaleUp();

  /**
   * @return scale up limit for given worker, -1 if no scale up limit is set for worker.
   */
  long getWorkerScaleUp(final String worker);

  /**
   * @return all workers that have set a scale up limit.
   */
  Collection<String> getWorkersWithScaleUp();

  /**
   * Returns a configured http port for a specified service. Returns -1 if no port is configured or the service unknown.
   */
  int getHttpPort(final String serviceName);

  /**
   * @return total maximum number of retries for a task.
   */
  long getMaxRetries();

  /**
   * @return time before an in-progress task is rolled back when no keepAlives are sent anymore.
   */
  long getTimeToLive();

  /**
   * @return if jobs should be resumed after restart.
   */
  boolean isResumeJobs();
}
