/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client;

/**
 * Enumeration defining the different HTTP methods supported by {@link RestClient}. Use the elements of this enum in the
 * generic
 * {@link RestClient#invoke(HttpMethod, String, org.eclipse.smila.datamodel.AnyMap, Attachments, org.apache.http.params.HttpParams)}
 * and {@link RestClient#invoke(HttpMethod, String, java.io.InputStream, org.apache.http.params.HttpParams)} methods to
 * specify the type of request to be executed.
 */
public enum HttpMethod {
  /** value for the HTTP method GET. */
  GET,
  /** value for the HTTP method POST. */
  POST,
  /** value for the HTTP method PUT. */
  PUT,
  /** value for the HTTP method DELETE. */
  DELETE;
}
