/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.impl.base;

import java.io.IOException;
import java.io.InputStream;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.http.client.RestException;

/**
 * Interface for objects that handle the HTTP resposonses for the {@link org.eclipse.smila.http.client.RestClient}. The
 * interface has been defined to be able to modify details of the HTTP result handling of the
 * {@link org.eclipse.smila.http.client.RestClient} for special use cases. Usually the default implementation provided
 * by this bundle is completely sufficient, so a standard user does not need to care about these things.
 */
public interface HttpResultHandler {
  /**
   * Check the HTTP response:
   * <ul>
   * <li>JSON response, success status code: return content stream
   * <li>no or non-JSON response, success status code: consume content and return null.
   * <li>error status code: throw appropriate {@link RestException}.
   * </ul>
   * */
  InputStream processHttpResponse(final HttpUriRequest request, final HttpResponse response) throws IOException,
    RestException;

  /** Read single JSON object from response stream. */
  Any handleJsonResult(final InputStream content) throws IOException;

  /** Create JSON bulk result object. */
  BulkResponseImpl handleJsonBulkResult(InputStream content) throws IOException;

}
