/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

/**
 * Id and State of current job run.
 */
public class JobRunInfo {
  /** job run id. */
  private final String _id;

  /** job state. */
  private final JobState _state;

  /**
   * create instance.
   * 
   * @param id
   *          job run id.
   * @param state
   *          job state.
   * */
  public JobRunInfo(final String id, final JobState state) {
    super();
    _id = id;
    _state = state;
  }

  /**
   * @return job run id.
   */
  public String getId() {
    return _id;
  }

  /**
   * @return job state.
   */
  public JobState getState() {
    return _state;
  }
}
