/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.events;

/**
 * Event sent by the jobmanager in preparation of finishing a job. Please note that more then one event might be
 * received for one job run if two JobManagers try to concurrently finish the same job run.
 */
public class PrepareToFinishEvent implements JobEvent {

  /** The name of the job to finish. */
  private final String _jobName;

  /** The id of the job run to finish. */
  private final String _jobRunId;

  /**
   * Constructor for PrepareToFinishEvent.
   * 
   * @param jobName
   *          the name of the job to be finished.
   * @param jobRunId
   *          the jon run id of the job to be finished.
   */
  public PrepareToFinishEvent(final String jobName, final String jobRunId) {
    _jobName = jobName;
    _jobRunId = jobRunId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getJobName() {
    return _jobName;
  }

  /**
   * Returns the job run id of the job to be finished.
   * 
   * @return the job run id of the job to be finished.
   */
  public String getJobRunId() {
    return _jobRunId;
  }
}
