/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.util.RecordMerger;
import org.eclipse.smila.importing.crawler.jdbc.JdbcCrawlingContext;
import org.eclipse.smila.jdbc.JdbcAccessService;
import org.eclipse.smila.jdbc.SqlExecutor;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class JdbcFetcherWorker
implements Worker {
    public static final String NAME = "jdbcFetcher";
    public static final String TASK_PARAM_FETCH_SQL = "fetchSql";
    public static final String TASK_PARAM_FETCH_PARAM_ATTRIBUTES = "fetchParameterAttributes";
    private static final String INPUT_SLOT = "recordsToFetch";
    private static final String OUTPUT_SLOT = "fetchedRecords";
    private final Log _log = LogFactory.getLog(this.getClass());
    private JdbcAccessService _jdbcAccess;

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        block11: {
            RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
            RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
            String fetchSql = taskContext.getTaskParameters().getStringValue(TASK_PARAM_FETCH_SQL);
            Record record = null;
            if (fetchSql != null && fetchSql.trim().length() != 0) {
                JdbcCrawlingContext crawlContext = new JdbcCrawlingContext(taskContext);
                List<String> fetchParams = this.getFetchParameters(crawlContext);
                Throwable throwable = null;
                Object var9_10 = null;
                try (SqlExecutor sqlExecutor = this._jdbcAccess.executePrepared(crawlContext.getDbUrl(), crawlContext.getDbProperties(), fetchSql, crawlContext.getMaxAttachmentSize(), crawlContext.getMessages());){
                    do {
                        if ((record = recordInput.getRecord()) == null) continue;
                        this.augmentRecord(crawlContext, fetchParams, sqlExecutor, record);
                        recordOutput.writeRecord(record);
                    } while (record != null && !taskContext.isCanceled());
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.copyRecords(taskContext, recordInput, recordOutput);
        }
    }

    private void augmentRecord(JdbcCrawlingContext crawlContext, List<String> fetchParams, SqlExecutor sqlExecutor, Record record) throws SQLException, IOException {
        ArrayList<Value> preparedStmtParams = new ArrayList<Value>();
        for (String attribute : fetchParams) {
            Any paramValue = (Any)record.getMetadata().get((Object)attribute);
            if (paramValue == null) {
                this._log.info((Object)("Record contains no value for attribute '" + attribute + "'. Skip fetching additional data."));
                return;
            }
            if (!paramValue.isValue()) {
                this._log.warn((Object)("Value '" + paramValue + "' of attribute '" + attribute + "' cannot be used for fetching. Skip fetching additional data."));
                return;
            }
            preparedStmtParams.add((Value)paramValue);
        }
        Record rec = sqlExecutor.executeAndMerge(preparedStmtParams);
        if (rec != null) {
            crawlContext.getMapper().mapNames(rec, null);
            RecordMerger.mergeRecords((Record)record, (Record)rec, (boolean)false);
        } else {
            this._log.info((Object)("Fetch SQL statement '" + sqlExecutor.getSql() + "' delivered no result for parameters: " + preparedStmtParams + ". Originally crawled record will be used in output."));
        }
    }

    private List<String> getFetchParameters(JdbcCrawlingContext crawlContext) {
        ArrayList<String> fetchParams = new ArrayList<String>();
        Any fetchParameterAttributes = (Any)crawlContext.getTaskContext().getTaskParameters().get((Object)TASK_PARAM_FETCH_PARAM_ATTRIBUTES);
        if (fetchParameterAttributes == null) {
            List<String> mappedIdAtts = this.getMappedIdAttributes(crawlContext);
            fetchParams.addAll(mappedIdAtts);
        } else {
            for (Any p : fetchParameterAttributes) {
                fetchParams.add(p.asValue().asString());
            }
        }
        return fetchParams;
    }

    private List<String> getMappedIdAttributes(JdbcCrawlingContext context) {
        ArrayList<String> mappedAtts = new ArrayList<String>();
        Any idColumns = context.getIdColumns();
        for (Any columnAny : idColumns) {
            String idCol = columnAny.asValue().asString();
            List mappedAtt = context.getMapper().get(idCol);
            mappedAtts.add((String)mappedAtt.get(0));
        }
        return mappedAtts;
    }

    private void copyRecords(TaskContext taskContext, RecordInput recordInput, RecordOutput recordOutput) throws ObjectStoreException, IOException {
        Record record;
        do {
            if ((record = recordInput.getRecord()) == null) continue;
            recordOutput.writeRecord(record);
        } while (record != null && !taskContext.isCanceled());
    }

    public void setJdbcAccessService(JdbcAccessService jdbcAccess) {
        this._jdbcAccess = jdbcAccess;
    }

    public void unsetJdbcAccessService(JdbcAccessService jdbcAccess) {
        if (this._jdbcAccess == jdbcAccess) {
            this._jdbcAccess = null;
        }
    }
}

