/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeLimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private static Timer timer = null;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TimerTask interruptTask;
    private boolean isInterrupted = false;

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("TimeLimitIteration", true);
        }
        return timer;
    }

    public TimeLimitIteration(Iteration<? extends E, ? extends X> iter, long timeLimit) {
        super(iter);
        assert (timeLimit > 0L) : "time limit must be a positive number, is: " + timeLimit;
        this.interruptTask = new TimerTask(){

            public void run() {
                TimeLimitIteration.this.interrupt();
            }
        };
        TimeLimitIteration.getTimer().schedule(this.interruptTask, timeLimit);
    }

    @Override
    public synchronized boolean hasNext() throws X {
        this.checkInterrupted();
        return super.hasNext();
    }

    @Override
    public synchronized E next() throws X {
        this.checkInterrupted();
        return super.next();
    }

    @Override
    public synchronized void remove() throws X {
        this.checkInterrupted();
        super.remove();
    }

    @Override
    protected void handleClose() throws X {
        this.interruptTask.cancel();
        super.handleClose();
    }

    private final void checkInterrupted() throws X {
        if (this.isInterrupted) {
            this.throwInterruptedException();
        }
    }

    protected abstract void throwInterruptedException() throws X;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt() {
        if (!this.isClosed()) {
            TimeLimitIteration timeLimitIteration = this;
            synchronized (timeLimitIteration) {
                this.isInterrupted = true;
            }
            try {
                this.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close iteration", (Throwable)e);
            }
        }
    }
}

