/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.Set;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.InstanceGlobals;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OFailureHandling;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.READWRITELOCK;
import org.apache.ode.bpel.rtrep.v2.SCOPE;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.ReadWriteLockChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

public class PROCESS
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private OProcess _oprocess;
    private InstanceGlobals _globals;

    public PROCESS(OProcess oProcess) {
        this._oprocess = oProcess;
    }

    public void run() {
        OdeInternalInstance odeInternalInstance = this.getBpelRuntime();
        Long l = odeInternalInstance.createScopeInstance(null, this._oprocess.processScope);
        this.createGlobals();
        ProcessInstanceStartedEvent processInstanceStartedEvent = new ProcessInstanceStartedEvent();
        processInstanceStartedEvent.setRootScopeId(l);
        processInstanceStartedEvent.setScopeDeclarationId(this._oprocess.processScope.getId());
        odeInternalInstance.sendEvent(processInstanceStartedEvent);
        ActivityInfo activityInfo = new ActivityInfo(this.genMonotonic(), this._oprocess.processScope, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        ScopeFrame scopeFrame = new ScopeFrame(this._oprocess.processScope, l, null, null, this._globals);
        PROCESS.instance((JacobRunnable)new SCOPE(activityInfo, scopeFrame, new LinkFrame(null)));
        PROCESS.object((ChannelListener)new ParentScopeChannelListener(activityInfo.parent){
            private static final long serialVersionUID = -8564969578471906493L;

            @Override
            public void compensate(OScope oScope, SynchChannel synchChannel) {
                assert (false);
            }

            @Override
            public void completed(FaultData faultData, Set<CompensationHandler> set) {
                OdeInternalInstance odeInternalInstance = PROCESS.this.getBpelRuntime();
                if (faultData == null) {
                    odeInternalInstance.completedOk();
                } else {
                    odeInternalInstance.completedFault(faultData);
                }
            }

            @Override
            public void cancelled() {
                this.completed(null, CompensationHandler.emptySet());
            }

            @Override
            public void failure(String string, Element element) {
                FaultData faultData = PROCESS.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, PROCESS.this._oprocess, string);
                this.completed(faultData, CompensationHandler.emptySet());
            }
        });
    }

    private void createGlobals() {
        this._globals = new InstanceGlobals();
        for (OBase oBase : this._oprocess.getChildren()) {
            if (!(oBase instanceof OScope.Variable)) continue;
            OScope.Variable variable = (OScope.Variable)oBase;
            ReadWriteLockChannel readWriteLockChannel = (ReadWriteLockChannel)this.newChannel(ReadWriteLockChannel.class);
            PROCESS.instance((JacobRunnable)new READWRITELOCK(readWriteLockChannel));
            this._globals._varLocks.put(variable, readWriteLockChannel);
        }
    }
}

