/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath20;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v2.xpath20.JaxpFunctionResolver;
import org.apache.ode.bpel.rtrep.v2.xpath20.JaxpVariableResolver;
import org.apache.ode.bpel.rtrep.v2.xpath20.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xpath20.WrappedFaultException;
import org.apache.ode.bpel.rtrep.v2.xpath20.XPath20ExpressionModifier;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPath20ExpressionRuntime
implements ExpressionLanguageRuntime {
    static final short NODE_TYPE = 1;
    static final short NODESET_TYPE = 2;
    static final short STRING_TYPE = 3;
    static final short BOOLEAN_TYPE = 4;
    static final short NUMBER_TYPE = 5;
    private static final Log __log = LogFactory.getLog(XPath20ExpressionRuntime.class);

    public void initialize(Map map) throws ConfigurationException {
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    public String evaluateAsString(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (String)this.evaluate(oExpression, evaluationContext, XPathConstants.STRING);
    }

    public boolean evaluateAsBoolean(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (Boolean)this.evaluate(oExpression, evaluationContext, XPathConstants.BOOLEAN);
    }

    public Number evaluateAsNumber(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        return (Number)this.evaluate(oExpression, evaluationContext, XPathConstants.NUMBER);
    }

    public List evaluate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List<Object> list;
        Object object = null;
        try {
            object = this.evaluate(oExpression, evaluationContext, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            object = this.evaluate(oExpression, evaluationContext, XPathConstants.STRING);
        }
        if (object instanceof List) {
            list = (ArrayList)object;
            __log.debug((Object)("Returned list of size " + list.size()));
            if (list.size() == 1 && !(list.get(0) instanceof Node)) {
                Object e = list.get(0);
                String string = e instanceof Date ? ISO8601DateParser.format((Date)((Date)e)) : (e instanceof DurationValue ? ((DurationValue)e).getStringValue() : e.toString());
                Document document = DOMUtils.newDocument();
                Element element = document.createElement("wrapper");
                Text text = document.createTextNode(string);
                element.appendChild(text);
                document.appendChild(element);
                list = Collections.singletonList(text);
            }
        } else if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            __log.debug((Object)("Returned node list of size " + nodeList.getLength()));
            list = new ArrayList(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                list.add(node);
            }
        } else if (object instanceof String) {
            Document document = DOMUtils.newDocument();
            Element element = document.createElement("wrapper");
            Text text = document.createTextNode((String)object);
            element.appendChild(text);
            document.appendChild(element);
            list = Collections.singletonList(text);
        } else {
            list = null;
        }
        return list;
    }

    public Node evaluateNode(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = this.evaluate(oExpression, evaluationContext);
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        return (Node)list.get(0);
    }

    public Calendar evaluateAsDate(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        List list = DOMUtils.toList((Object)this.evaluate(oExpression, evaluationContext));
        if (list.size() == 0) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "No results for expression: " + oExpression);
        }
        if (list.size() > 1) {
            throw new FaultException(oExpression.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + oExpression);
        }
        Object object = list.get(0);
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return calendar;
        }
        if (object instanceof Element) {
            object = ((Element)object).getTextContent();
        }
        if (object instanceof Text) {
            object = ((Text)object).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal((String)object.toString());
        }
        catch (Exception exception) {
            String string = "Invalid date format: " + list;
            __log.error((Object)string);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string);
        }
    }

    public Duration evaluateAsDuration(OExpression oExpression, EvaluationContext evaluationContext) throws FaultException {
        String string = this.evaluateAsString(oExpression, evaluationContext);
        try {
            return new Duration(string);
        }
        catch (Exception exception) {
            String string2 = "Invalid duration: " + string;
            __log.error((Object)string2, (Throwable)exception);
            throw new FaultException(oExpression.getOwner().constants.qnInvalidExpressionValue, string2);
        }
    }

    private Object evaluate(OExpression oExpression, EvaluationContext evaluationContext, QName qName) throws FaultException {
        try {
            Object object;
            Node node;
            OXPath20ExpressionBPEL20 oXPath20ExpressionBPEL20 = (OXPath20ExpressionBPEL20)oExpression;
            System.setProperty("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl");
            System.setProperty("javax.xml.xpath.XPathFactory:http://jdom.org/jaxp/xpath/jdom", "net.sf.saxon.xpath.XPathFactoryImpl");
            System.setProperty("javax.xml.xpath.XPathFactory:http://www.xom.nu/jaxp/xpath/xom", "net.sf.saxon.xpath.XPathFactoryImpl");
            System.setProperty("javax.xml.xpath.XPathFactory:http://www.dom4j.org/jaxp/xpath/dom4j", "net.sf.saxon.xpath.XPathFactoryImpl");
            XPathFactory xPathFactory = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om");
            JaxpFunctionResolver jaxpFunctionResolver = new JaxpFunctionResolver(evaluationContext, oXPath20ExpressionBPEL20);
            JaxpVariableResolver jaxpVariableResolver = new JaxpVariableResolver(evaluationContext, oXPath20ExpressionBPEL20, ((XPathFactoryImpl)xPathFactory).getConfiguration());
            xPathFactory.setXPathFunctionResolver(jaxpFunctionResolver);
            xPathFactory.setXPathVariableResolver(jaxpVariableResolver);
            XPath xPath = xPathFactory.newXPath();
            xPath.setNamespaceContext((NamespaceContext)oXPath20ExpressionBPEL20.namespaceCtx);
            XPathExpression xPathExpression = xPath.compile(((OXPath10Expression)oExpression).xpath);
            Node node2 = node = evaluationContext.getRootNode() == null ? DOMUtils.newDocument() : evaluationContext.getRootNode();
            if (oXPath20ExpressionBPEL20.insertMissingData) {
                object = new XPath20ExpressionModifier(oXPath20ExpressionBPEL20.namespaceCtx, ((XPathFactoryImpl)xPathFactory).getConfiguration().getNamePool());
                ((XPath20ExpressionModifier)object).insertMissingData(xPathExpression, evaluationContext.getRootNode());
            }
            if ((object = xPathExpression.evaluate(node, qName)) != null && __log.isDebugEnabled()) {
                __log.debug((Object)("Expression " + oExpression.toString() + " generated result " + object + " - type=" + object.getClass().getName()));
                if (evaluationContext.getRootNode() != null) {
                    __log.debug((Object)("Was using context node " + DOMUtils.domToString((Node)evaluationContext.getRootNode())));
                }
            }
            return object;
        }
        catch (XPathExpressionException xPathExpressionException) {
            Throwable throwable;
            Throwable throwable2;
            Throwable throwable3 = throwable2 = xPathExpressionException.getCause() != null ? xPathExpressionException.getCause() : xPathExpressionException;
            if (throwable2 instanceof DynamicError && (throwable = ((DynamicError)throwable2).getException()) != null && (throwable2 = throwable).getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, throwable2.getMessage(), throwable2);
        }
        catch (WrappedFaultException wrappedFaultException) {
            __log.debug((Object)"Could not evaluate expression because of ", (Throwable)wrappedFaultException);
            throw (FaultException)wrappedFaultException.getCause();
        }
        catch (Throwable throwable) {
            __log.debug((Object)"Could not evaluate expression because of ", throwable);
            throw new FaultException(oExpression.getOwner().constants.qnSubLanguageExecutionFault, throwable.getMessage(), throwable);
        }
    }
}

