/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.SourceType;
import org.eclipse.smila.processing.util.ResultCollector;

public class JSONReaderPipelet
implements Pipelet {
    public static final String INPUT_NAME_PROPERTY = "inputName";
    public static final String INPUT_TYPE_PROPERTY = "inputType";
    public static final String OUTPUT_ATTRIBUTE_PROPERTY = "outputAttribute";
    private String _inputName;
    private SourceType _inputType;
    private String _outputAttribute;
    private AnyMap _config;
    private final Log _log = LogFactory.getLog(this.getClass());

    public void configure(AnyMap config) throws ProcessingException {
        this._config = config;
        ParameterAccessor paramAccessor = new ParameterAccessor(config);
        this._inputName = paramAccessor.getRequiredParameter(INPUT_NAME_PROPERTY);
        String inputType = paramAccessor.getRequiredParameter(INPUT_TYPE_PROPERTY);
        try {
            this._inputType = SourceType.valueOf(inputType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException("Illegal value for input type: " + inputType);
        }
        this._outputAttribute = paramAccessor.getParameter(OUTPUT_ATTRIBUTE_PROPERTY, null);
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(this._config);
        ResultCollector results = new ResultCollector(paramAccessor, this._log, false);
        IpcAnyReader reader = new IpcAnyReader();
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            paramAccessor.setCurrentRecord(id);
            try {
                Any object = null;
                AnyMap metadata = blackboard.getMetadata(id);
                if (this._inputType == SourceType.ATTACHMENT) {
                    InputStream stream = blackboard.getAttachmentAsStream(id, this._inputName);
                    if (stream != null) {
                        object = reader.readJsonStream(stream);
                    }
                } else {
                    Iterator it;
                    Any input = (Any)metadata.get((Object)this._inputName);
                    if (input != null && (it = input.iterator()).hasNext()) {
                        object = reader.readJsonObject(((Any)it.next()).toString());
                    }
                }
                if (this._outputAttribute == null) {
                    if (object instanceof AnyMap) {
                        for (Map.Entry entry : object.asMap().entrySet()) {
                            if ("_recordid".equals(entry.getKey())) continue;
                            metadata.put((String)entry.getKey(), (Any)entry.getValue());
                        }
                    }
                } else if (object != null) {
                    metadata.put(this._outputAttribute, object);
                }
                results.addResult(id);
            }
            catch (Exception e) {
                results.addFailedResult(id, e);
            }
            ++n2;
        }
        return results.getResultIds();
    }
}

