/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class RemoveAttributePipelet
implements Pipelet {
    private static final String PARAM_ATTRIBUTE = "removeAttribute";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor parameters = new ParameterAccessor(blackboard, this._configuration);
        ResultCollector resultCollector = new ResultCollector(parameters, this._log, false);
        if (recordIds != null && recordIds.length > 0) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    AnyMap record = blackboard.getMetadata(id);
                    if (record != null) {
                        parameters.setCurrentRecord(id);
                        String removeAttribute = parameters.getParameter(PARAM_ATTRIBUTE, null);
                        if (removeAttribute != null) {
                            blackboard.getMetadata(id).remove((Object)removeAttribute);
                        }
                    }
                    resultCollector.addResult(id);
                }
                catch (Exception ex) {
                    resultCollector.addFailedResult(id, ex);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }
}

