/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.internal.HttpServerProperties;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.ipc.IpcException;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.json.JsonFactory;
import org.eclipse.smila.ipc.json.JsonStreamWriter;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;

public class JsonHttpUtils {
    public static final IpcRecordWriter IPC_RECORD_WRITER = new IpcRecordWriter();
    public static final IpcRecordReader IPC_RECORD_READER = new IpcRecordReader();
    public static final IpcAnyWriter IPC_ANY_WRITER = new IpcAnyWriter();
    private static final FileItemFactory FILEITEM_FACTORY = new DiskFileItemFactory(Integer.MAX_VALUE, null);
    private static final String KEY_MAX_RECORD_SIZE = "http.json.maxRequestRecordSize";
    private static final String DEFAULT_MAX_RECORD_SIZE = "1g";
    private static final HttpServerProperties CONFIGURATION = new HttpServerProperties();
    private static final long MAX_RECORD_SIZE = CONFIGURATION.getDataSize("http.json.maxRequestRecordSize", "1g");

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory / 4L < MAX_RECORD_SIZE) {
            LogFactory.getLog(JsonHttpUtils.class).warn((Object)("Request record size limit is set to " + CONFIGURATION.getProperty(KEY_MAX_RECORD_SIZE, DEFAULT_MAX_RECORD_SIZE) + " which is greater than 25% of maximum allowed heap memory." + " OutOfMemory errors may result when records of this size are actually sent in requests."));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Record convertRequest(HttpExchange exchange) throws IpcException {
        Record inputRecord = null;
        if (!this.hasRequestContent(exchange)) return this.convertGetRequest(exchange);
        String encoding = exchange.getCharacterEncoding();
        if (encoding == null) return this.convertPostRequest(exchange);
        if (!"UTF-8".equalsIgnoreCase(encoding)) throw new IpcException("Unsupported character encoding '" + encoding + "'. UTF-8 is required");
        return this.convertPostRequest(exchange);
    }

    public Record convertGetRequest(HttpExchange he) throws IpcException {
        String httpQueryString = he.getQueryString();
        if (httpQueryString == null || httpQueryString.trim().length() == 0) {
            return null;
        }
        try {
            Record record = DataFactory.DEFAULT.createRecord();
            Enumeration<String> paramNames = he.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String parameter = paramNames.nextElement();
                String[] values = he.getParameterValues(parameter);
                if (values.length == 1) {
                    record.getMetadata().put(parameter, (Any)this.parseValue(values[0]));
                    continue;
                }
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    record.getMetadata().add(parameter, (Any)this.parseValue(value));
                    ++n2;
                }
            }
            return record;
        }
        catch (Exception e) {
            throw new IpcException("Error parsing GET request", (Throwable)e);
        }
    }

    public Record convertPostRequest(HttpExchange he) throws IpcException {
        Record record;
        InputStream in;
        String requestMethod;
        block6: {
            this.checkContentLength(he);
            requestMethod = he.getRequestMethod();
            in = null;
            HttpServletRequest servletRequest = he.getAsServletRequest();
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) break block6;
            Record record2 = this.parseMultiPartRequest(servletRequest);
            IOUtils.closeQuietly((InputStream)in);
            return record2;
        }
        try {
            in = he.getRequestStream();
            record = this.parseMetadataContent(in);
        }
        catch (Exception e) {
            try {
                String message = e.getMessage();
                if (message == null && e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                throw new IpcException("Error parsing record in " + requestMethod + " request: " + message, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return record;
    }

    private void checkContentLength(HttpExchange he) throws IpcException {
        long size;
        String contentLength = he.getRequestHeader("Content-Length");
        if (contentLength != null && (size = Long.parseLong(contentLength)) > MAX_RECORD_SIZE) {
            throw new IpcException("The request's content-length of " + contentLength + " exceeds the configured maximum of " + MAX_RECORD_SIZE);
        }
    }

    private Record parseMetadataContent(InputStream in) throws IOException {
        LimitedInputStream limitedStream = new LimitedInputStream(in, MAX_RECORD_SIZE){

            protected void raiseError(long pSizeMax, long pCount) throws IOException {
                throw new IOException("The request's content-length (>" + pCount + ") exceeds the configured maximum length of " + MAX_RECORD_SIZE);
            }
        };
        return IPC_RECORD_READER.readJsonStream((InputStream)limitedStream);
    }

    private Record parseMultiPartRequest(HttpServletRequest multiPartRequest) throws IOException, FileUploadException {
        long maxSize = MAX_RECORD_SIZE;
        ServletFileUpload upload = new ServletFileUpload(FILEITEM_FACTORY);
        upload.setSizeMax(maxSize);
        upload.setFileSizeMax(maxSize);
        FileItemIterator parts = upload.getItemIterator(multiPartRequest);
        if (!parts.hasNext()) {
            return null;
        }
        FileItemStream metadataPart = parts.next();
        Record record = this.readMetadata(metadataPart);
        while (parts.hasNext()) {
            FileItemStream attachmentPart = parts.next();
            String attachmentName = attachmentPart.getFieldName();
            byte[] attachment = this.readAttachment(attachmentPart);
            record.setAttachment(attachmentName, attachment);
            maxSize -= (long)attachment.length;
        }
        return record;
    }

    private Record readMetadata(FileItemStream metadataPart) throws IOException {
        InputStream jsonStream = metadataPart.openStream();
        try {
            Record record = this.parseMetadataContent(jsonStream);
            return record;
        }
        finally {
            IOUtils.closeQuietly((InputStream)jsonStream);
        }
    }

    private byte[] readAttachment(FileItemStream attachmentPart) throws IOException {
        InputStream binaryStream = attachmentPart.openStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)binaryStream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)binaryStream);
        }
    }

    public boolean hasRequestContent(HttpExchange exchange) {
        String contentLength = exchange.getRequestHeader("Content-Length");
        if (contentLength != null) {
            long length = Long.parseLong(contentLength);
            return length > 0L;
        }
        String transferEnc = exchange.getRequestHeader("Transfer-Encoding");
        if (transferEnc != null) {
            return "chunked".equalsIgnoreCase(transferEnc);
        }
        return false;
    }

    private Value parseValue(String value) {
        try {
            long longValue = Long.parseLong(value);
            return DataFactory.DEFAULT.createLongValue(Long.valueOf(longValue));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double doubleValue = Double.parseDouble(value);
                return DataFactory.DEFAULT.createDoubleValue(Double.valueOf(doubleValue));
            }
            catch (NumberFormatException numberFormatException2) {
                if ("true".equalsIgnoreCase(value.trim())) {
                    return DataFactory.DEFAULT.createBooleanValue(Boolean.valueOf(true));
                }
                if ("false".equalsIgnoreCase(value.trim())) {
                    return DataFactory.DEFAULT.createBooleanValue(Boolean.valueOf(false));
                }
                return DataFactory.DEFAULT.createStringValue(value);
            }
        }
    }

    public boolean prepareResponseHeader(HttpExchange exchange, int statusCode, boolean hasResponseBody) {
        boolean closeConnection = false;
        exchange.setResponseStatus(statusCode);
        String connectionHeader = exchange.getRequestHeader("Connection");
        if (connectionHeader != null && connectionHeader.equals("close")) {
            closeConnection = true;
            exchange.setResponseHeader("Connection", "close");
        } else {
            exchange.setResponseHeader("Connection", "keep-alive");
            exchange.setResponseHeader("Keep-Alive", "timeout=0");
        }
        if (hasResponseBody && statusCode != 204) {
            exchange.setResponseHeader("Content-Type", "application/json; charset=utf-8");
            exchange.setResponseHeader("Transfer-Encoding", "chunked");
        } else {
            exchange.setResponseHeader("Content-Length", "0");
        }
        return closeConnection;
    }

    public void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        if (resultObject instanceof Record) {
            Record resultRecord = (Record)resultObject;
            IPC_RECORD_WRITER.writeJsonStream(resultRecord, responseStream);
        } else if (resultObject instanceof Any) {
            Any resultAny = (Any)resultObject;
            IPC_ANY_WRITER.writeJsonStream(resultAny, responseStream);
        } else if (resultObject != null) {
            ObjectMapper mapper = this.getObjectMapper();
            mapper.writeValue(responseStream, resultObject);
        }
    }

    public int getErrorStatus(Throwable ex) {
        if (ex instanceof UnsupportedMethodException) {
            return 405;
        }
        if (ex instanceof IpcException || ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex instanceof NotFoundHTTPResult || ex.getCause() instanceof NotFoundHTTPResult) {
            return 404;
        }
        if (ex instanceof HttpException) {
            return ((HttpException)ex).getStatus();
        }
        return 500;
    }

    public void writeErrorDetails(HttpExchange exchange, Throwable error) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonStreamWriter jsonWriter = jsonFactory.newStreamWriter(exchange.getResponseStream());
        if (error instanceof IpcException) {
            ((IpcException)error).write((IpcStreamWriter)jsonWriter);
        } else if (error instanceof HttpException) {
            new IpcException(((HttpException)error).getReason(), error.getCause()).write((IpcStreamWriter)jsonWriter);
        } else {
            IpcException.write((IpcStreamWriter)jsonWriter, (Throwable)error);
        }
    }

    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        objectMapper.getSerializationConfig().setDateFormat((DateFormat)ValueFormatHelper.getDefaultDateTimeFormat());
        return objectMapper;
    }
}

