/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.JobRun;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowAction;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class JobRunImpl
implements JobRun {
    private final String _jobRunId;
    private final JobDefinition _jobDef;
    private final WorkflowDefinition _workflowDef;
    private WorkflowAction _startAction;
    private final List<WorkflowAction> _actions = new ArrayList<WorkflowAction>();
    private final MultiValueMap<String, WorkflowAction> _inputBucketToAction = new MultiValueMap();
    private final MultiValueMap<String, WorkflowAction> _outputBucketToAction = new MultiValueMap();
    private final Map<String, Bucket> _buckets = new HashMap<String, Bucket>();
    private final Map<WorkflowAction, Map<String, Bucket>> _actionInputBuckets = new HashMap<WorkflowAction, Map<String, Bucket>>();
    private final Map<WorkflowAction, Map<String, Bucket>> _actionOutputBuckets = new HashMap<WorkflowAction, Map<String, Bucket>>();
    private final Map<String, WorkerDefinition> _workers = new HashMap<String, WorkerDefinition>();
    private final AnyMap _parameters = DataFactory.DEFAULT.createAnyMap();
    private final Map<String, BucketDefinition> _bucketDefinitions = new HashMap<String, BucketDefinition>();
    private final ArrayList<WorkflowAction> _barrierActions = new ArrayList();
    private final MultiValueMap<WorkflowAction, WorkflowAction> _barrierDependencies = new MultiValueMap();
    private final MultiValueMap<WorkflowAction, WorkflowAction> _actionsToBarriers = new MultiValueMap();

    public JobRunImpl(String runId, String jobName, RunStorage runStorage, DefinitionPersistence definitions) throws Exception {
        AnyMap jobRunData = runStorage.getJobRunData(jobName, true);
        AnyMap jobDefinitionMap = jobRunData.getMap("jobDefinition");
        AnyMap workflowDefinitionMap = jobRunData.getMap("workflowDefinition");
        AnySeq bucketsSeq = jobRunData.getSeq("bucketDefinitions");
        if (bucketsSeq != null && bucketsSeq.size() > 0) {
            for (AnyMap bucketsAny : bucketsSeq) {
                this._bucketDefinitions.put(bucketsAny.getStringValue("name"), new BucketDefinition(bucketsAny));
            }
        }
        this._jobRunId = runId;
        this._jobDef = new JobDefinition(jobDefinitionMap);
        this._workflowDef = new WorkflowDefinition(workflowDefinitionMap);
        this.compileWorkflow(definitions);
    }

    private void compileWorkflow(DefinitionPersistence definitions) throws PersistenceException {
        if (this._jobDef.getParameters() != null) {
            this._parameters.putAll((Map)this._jobDef.getParameters());
        }
        if (this._workflowDef.getParameters() != null) {
            this._parameters.putAll((Map)this._workflowDef.getParameters());
        }
        this._startAction = this._workflowDef.getStartAction();
        this._actions.add(this._startAction);
        this.compileWorkflowAction(this._startAction, definitions);
        if (this._workflowDef.getActions() != null) {
            for (WorkflowAction action : this._workflowDef.getActions()) {
                this._actions.add(action);
                this.compileWorkflowAction(action, definitions);
                if (!this._workers.get(action.getWorker()).getModes().contains((Object)WorkerDefinition.Mode.BARRIER)) continue;
                this._barrierActions.add(action);
            }
            this.compileBarriers();
        }
    }

    private void compileWorkflowAction(WorkflowAction action, DefinitionPersistence definitions) throws PersistenceException {
        String workerName = action.getWorker();
        WorkerDefinition workerDef = this.getWorkerDefinition(definitions, workerName);
        this._actionInputBuckets.put(action, new HashMap());
        this._actionOutputBuckets.put(action, new HashMap());
        Map<String, String> actionInputSlotsDefinition = action.getInput();
        Collection<WorkerDefinition.Input> workerInputSlots = workerDef.getInput();
        this.compileActionSlotConfigurations(action, definitions, actionInputSlotsDefinition, workerInputSlots, true);
        Map<String, String> actionOutputSlotsDefinition = action.getOutput();
        Collection<WorkerDefinition.Output> workerOutputSlots = workerDef.getOutput();
        this.compileActionSlotConfigurations(action, definitions, actionOutputSlotsDefinition, workerOutputSlots, false);
    }

    private void compileActionSlotConfigurations(WorkflowAction action, DefinitionPersistence definitions, Map<String, String> actionSlots, Collection<? extends WorkerDefinition.InputOutput<?>> workerSlots, boolean isInputSlots) throws PersistenceException {
        if (actionSlots != null) {
            for (Map.Entry<String, String> slot : actionSlots.entrySet()) {
                String slotName = slot.getKey();
                String bucketName = slot.getValue();
                Bucket bucket = this._buckets.get(bucketName);
                if (bucket == null) {
                    BucketDefinition bucketDef = this._bucketDefinitions.get(bucketName);
                    boolean isPersistent = true;
                    if (bucketDef == null) {
                        String slotDataObjectType = this.getSlotType(slotName, workerSlots);
                        isPersistent = false;
                        bucketDef = new BucketDefinition(bucketName, slotDataObjectType);
                    }
                    DataObjectTypeDefinition dot = definitions.getDataObjectType(bucketDef.getDataObjectType());
                    bucket = new Bucket(bucketDef, dot, isPersistent, this._parameters);
                    this._buckets.put(bucketName, bucket);
                }
                if (isInputSlots) {
                    this._actionInputBuckets.get(action).put(slotName, bucket);
                    this._inputBucketToAction.add((Object)bucketName, (Object)action);
                    continue;
                }
                this._actionOutputBuckets.get(action).put(slotName, bucket);
                this._outputBucketToAction.add((Object)bucketName, (Object)action);
            }
        }
    }

    private String getSlotType(String slotName, Collection<? extends WorkerDefinition.InputOutput<?>> slots) {
        if (slots != null) {
            for (WorkerDefinition.InputOutput<?> iterableElement : slots) {
                if (!iterableElement.getName().equals(slotName)) continue;
                return iterableElement.getType();
            }
        }
        return null;
    }

    private WorkerDefinition getWorkerDefinition(DefinitionPersistence definitions, String workerName) throws PersistenceException {
        WorkerDefinition workerDef = this._workers.get(workerName);
        if (workerDef == null) {
            workerDef = definitions.getWorker(workerName);
            this._workers.put(workerName, workerDef);
        }
        return workerDef;
    }

    private void compileBarriers() {
        if (!this._barrierActions.isEmpty()) {
            for (WorkflowAction barrier : this._barrierActions) {
                this.findActionsForBarrier(barrier, barrier);
            }
        }
    }

    private void findActionsForBarrier(WorkflowAction action, WorkflowAction barrier) {
        Map<String, Bucket> inputBucketsForAction = this.getInputBucketsForAction(action);
        if (inputBucketsForAction != null) {
            for (Bucket bucket : inputBucketsForAction.values()) {
                Collection inputActions = (Collection)this._outputBucketToAction.get((Object)bucket.getBucketDefinition().getName());
                if (inputActions == null) continue;
                for (WorkflowAction inputAction : inputActions) {
                    if (this._actionsToBarriers.containsKey((Object)inputAction) && ((List)this._actionsToBarriers.get((Object)inputAction)).contains(barrier)) continue;
                    this._actionsToBarriers.add((Object)inputAction, (Object)barrier);
                    if (inputAction == barrier) continue;
                    if (this._barrierActions.contains(inputAction)) {
                        this._barrierDependencies.add((Object)barrier, (Object)inputAction);
                    }
                    this.findActionsForBarrier(inputAction, barrier);
                }
            }
        }
    }

    @Override
    public String getJobName() {
        return this._jobDef.getName();
    }

    @Override
    public String getJobRunId() {
        return this._jobRunId;
    }

    @Override
    public WorkflowAction getStartAction() {
        return this._startAction;
    }

    @Override
    public WorkflowAction getAction(int position) {
        return this._actions.get(position);
    }

    @Override
    public AnyMap getParameters() {
        return this._parameters;
    }

    @Override
    public JobDefinition getJobDefinition() {
        return this._jobDef;
    }

    @Override
    public Map<String, Bucket> getInputBucketsForAction(WorkflowAction action) {
        return this._actionInputBuckets.get(action);
    }

    @Override
    public Map<String, Bucket> getOutputBucketsForAction(WorkflowAction action) {
        return this._actionOutputBuckets.get(action);
    }

    @Override
    public Collection<Bucket> getBuckets() {
        return this._buckets.values();
    }

    @Override
    public Bucket getBucket(String bucketName) {
        return this._buckets.get(bucketName);
    }

    @Override
    public boolean isTriggeredBy(Bucket triggeringBucket) {
        if (this._startAction.getInput() != null) {
            for (String inputBucketName : this._startAction.getInput().values()) {
                Bucket inputBucket = this.getBucket(inputBucketName);
                if (!inputBucket.isPersistent() || !triggeringBucket.getBucketId().equals(inputBucket.getBucketId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<WorkflowAction> getTriggeredActionsForBucket(String bucketName) {
        return (Collection)this._inputBucketToAction.get((Object)bucketName);
    }

    @Override
    public Collection<WorkflowAction> getActionsWritingToBucket(String bucketName) {
        return (Collection)this._outputBucketToAction.get((Object)bucketName);
    }

    @Override
    public boolean hasBarriers() {
        return !this._barrierActions.isEmpty();
    }

    @Override
    public Collection<WorkflowAction> getBarrierActions() {
        return this._barrierActions;
    }

    @Override
    public Collection<WorkflowAction> getPrecedingBarriers(WorkflowAction barrier) {
        return (Collection)this._barrierDependencies.get((Object)barrier);
    }

    @Override
    public Collection<WorkflowAction> getBarriersForAction(WorkflowAction action) {
        return (Collection)this._actionsToBarriers.get((Object)action);
    }

    @Override
    public Collection<Bucket> getTriggerBuckets() {
        ArrayList<Bucket> startBuckets = new ArrayList<Bucket>();
        if (this._startAction.getInput() != null) {
            for (String inputBucketName : this._startAction.getInput().values()) {
                Bucket inputBucket = this.getBucket(inputBucketName);
                if (!inputBucket.isPersistent()) continue;
                startBuckets.add(inputBucket);
            }
        }
        return startBuckets;
    }
}

