/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.helper;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.InvalidJobException;
import org.eclipse.smila.jobmanager.JobRunDataProvider;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.JobTaskProcessor;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.workermanager.WorkerManager;

public class BulkbuilderTaskProvider {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Map<String, Task> _jobsAndTasks = new ConcurrentHashMap<String, Task>();
    private final TaskManager _taskManager;
    private final WorkerManager _workerManager;
    private final JobRunDataProvider _jobRunDataProvider;
    private final JobTaskProcessor _jobTaskProcessor;
    private final String _workerName;

    public BulkbuilderTaskProvider(TaskManager taskManager, WorkerManager workerManager, JobRunDataProvider jobDataProvider, JobTaskProcessor jobTaskProcessor, String workerName) {
        this._taskManager = taskManager;
        this._workerManager = workerManager;
        this._jobRunDataProvider = jobDataProvider;
        this._jobTaskProcessor = jobTaskProcessor;
        this._workerName = workerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getInitialTask(String jobName) throws BulkbuilderException {
        try {
            Task task = this._jobsAndTasks.get(jobName);
            if (task == null) {
                BulkbuilderTaskProvider bulkbuilderTaskProvider = this;
                synchronized (bulkbuilderTaskProvider) {
                    task = this._jobsAndTasks.get(jobName);
                    if (task == null) {
                        task = this._jobTaskProcessor.getInitialTask(this._workerName, jobName);
                        if (task != null) {
                            if (this._log.isDebugEnabled()) {
                                this._log.debug((Object)("got new initial task: " + task.getTaskId()));
                            }
                            this._jobsAndTasks.put(jobName, task);
                            this._workerManager.addKeepAliveTask(task);
                        } else {
                            throw new BulkbuilderException("Couldn't get initial task for job " + jobName);
                        }
                    }
                }
            }
            return task;
        }
        catch (JobManagerException te) {
            throw new InvalidJobException("Error getting initial task for job '" + jobName + "'.", te);
        }
    }

    public Task finishTask(String jobName, ResultDescription resultDescription) throws BulkbuilderException {
        Task task = this._jobsAndTasks.remove(jobName);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("finishing initial task: " + task));
        }
        if (task != null) {
            try {
                this._workerManager.removeKeepAliveTask(task);
                this._taskManager.finishTask(this._workerName, task.getTaskId(), resultDescription);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("Finished task for job '" + jobName + "'."));
                }
                return task;
            }
            catch (TaskmanagerException te) {
                throw new BulkbuilderException("Error finishing task '" + task.getTaskId() + "' for job '" + jobName + "'.", te);
            }
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Could not find task to be finished for job '" + jobName + "'."));
        }
        return null;
    }

    public void removeTask(Task task) {
        Iterator<Task> iter = this._jobsAndTasks.values().iterator();
        while (iter.hasNext()) {
            Task foundTask = iter.next();
            if (!foundTask.getTaskId().equals(task.getTaskId())) continue;
            iter.remove();
            return;
        }
    }

    public void checkJobActive(String jobName) throws BulkbuilderException {
        try {
            JobRunInfo jobRunInfo = this._jobRunDataProvider.getJobRunInfo(jobName);
            if (jobRunInfo == null) {
                throw new InvalidJobException("No job run info for job '" + jobName + "', job not defined or not active.");
            }
            JobState jobState = jobRunInfo.getState();
            if (jobState != JobState.RUNNING && jobState != JobState.FINISHING) {
                throw new InvalidJobException("Cannot commit in job '" + jobName + "' because it is in state '" + jobState + "'");
            }
        }
        catch (JobManagerException ex) {
            throw new BulkbuilderException("Error checking state of job '" + jobName + "'", ex);
        }
    }
}

