/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.shared.common.sanity.SanityManager;

public class CachingLogicalConnection
extends LogicalConnection {
    private StatementCacheInteractor cacheInteractor;

    public CachingLogicalConnection(Connection physicalConnection, ClientPooledConnection pooledConnection, JDBCStatementCache stmtCache) throws SqlException {
        super(physicalConnection, pooledConnection);
        this.cacheInteractor = new StatementCacheInteractor(stmtCache, physicalConnection);
    }

    public synchronized void close() throws SQLException {
        if (this.cacheInteractor != null) {
            this.cacheInteractor.closeOpenLogicalStatements();
            this.cacheInteractor = null;
            super.close();
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(sql);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareStatement(sql, autoGeneratedKeys);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkForNullPhysicalConnection();
        PreparedStatement ps = null;
        if (columnIndexes != null && columnIndexes.length > 1) {
            ps = super.prepareStatement(sql, columnIndexes);
            SanityManager.THROWASSERT("CachingLogicalConnection is missing the capability to handle prepareStatement with an int array with more than one elemenet.");
        } else {
            int generatedKeys = 1;
            if (columnIndexes == null || columnIndexes.length == 0) {
                generatedKeys = 2;
            }
            ps = this.cacheInteractor.prepareStatement(sql, generatedKeys);
        }
        return ps;
    }

    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkForNullPhysicalConnection();
        PreparedStatement ps = null;
        if (columnNames != null && columnNames.length > 1) {
            ps = super.prepareStatement(sql, columnNames);
            SanityManager.THROWASSERT("CachingLogicalConnection is missing the capability to handle prepareStatement with a string array with more than one elemenet.");
        } else {
            int generatedKeys = 1;
            if (columnNames == null || columnNames.length == 0) {
                generatedKeys = 2;
            }
            ps = this.cacheInteractor.prepareStatement(sql, generatedKeys);
        }
        return ps;
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareCall(sql);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkForNullPhysicalConnection();
        return this.cacheInteractor.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }
}

