/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.httphandler.AProcessHandler;

public class PipeletProcessHandler
extends AProcessHandler {
    private PipeletTracker _tracker;

    @Override
    public String[] doProcess(String pipeletName, Blackboard blackboard, String[] recordIds) throws BlackboardAccessException, ProcessingException {
        Pipelet pipelet = this.createPipelet(pipeletName);
        this.configurePipelet(pipelet, blackboard.getRecord(recordIds[0]));
        return pipelet.process(blackboard, recordIds);
    }

    private Pipelet createPipelet(String pipeletName) {
        Class<? extends Pipelet> pipeletClass = this._tracker.getRegisteredPipelets().get(pipeletName);
        if (pipeletClass == null) {
            throw new IllegalArgumentException("Unknown pipelet class " + pipeletName);
        }
        try {
            return pipeletClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException("Could not create pipelet of class " + pipeletName, ex);
        }
    }

    private void configurePipelet(Pipelet pipelet, Record inputRecord) {
        Any configuration = (Any)inputRecord.getMetadata().get((Object)"_configuration");
        if (configuration != null && configuration.isMap()) {
            try {
                pipelet.configure(configuration.asMap());
            }
            catch (ProcessingException ex) {
                throw new IllegalArgumentException("Invalid configuration for pipelet of class " + pipelet.getClass().getName(), (Throwable)((Object)ex));
            }
        }
    }

    public void setPipeletTracker(PipeletTracker tracker) {
        this._tracker = tracker;
    }

    public void unsetPipeletTracker(PipeletTracker tracker) {
        if (this._tracker == tracker) {
            this._tracker = null;
        }
    }
}

