/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import java.net.MalformedURLException;
import java.util.Set;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.ProcessingException;

public class PipeletsHandler
extends JsonRequestHandler {
    private PipeletTracker _pipeletTracker;

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        return this.getPipelineList(this.getRequestHost(exchange), requestUri);
    }

    private Object getPipelineList(String requestHost, String requestUri) throws MalformedURLException {
        AnyMap result = FACTORY.createAnyMap();
        AnySeq pipelets = FACTORY.createAnySeq();
        Set<String> names = this._pipeletTracker.getRegisteredPipeletDescriptions().keySet();
        for (String name : names) {
            AnyMap pipelet = FACTORY.createAnyMap();
            pipelet.put("class", name);
            pipelet.put("url", URLCreator.create((String)requestHost, (String)requestUri, (String)name).toString());
            pipelets.add((Object)pipelet);
        }
        result.put("pipelets", (Any)pipelets);
        return result;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof ProcessingException) {
            return ((ProcessingException)((Object)ex)).isRecoverable() ? 500 : 400;
        }
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    public void setPipeletTracker(PipeletTracker tracker) {
        this._pipeletTracker = tracker;
    }

    public void unsetPipeletTracker(PipeletTracker tracker) {
        if (this._pipeletTracker == tracker) {
            this._pipeletTracker = null;
        }
    }
}

