/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.util;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.util.PropertyNameMapper;
import org.eclipse.smila.taskworker.TaskContext;

public abstract class CrawlingContext {
    private final TaskContext _taskContext;
    private final String _jobName;
    private final String _jobRunId;
    private final String _dataSource;
    private final PropertyNameMapper _mapper;

    public CrawlingContext(TaskContext taskContext, boolean normalize) {
        this._taskContext = taskContext;
        this._jobName = (String)taskContext.getTask().getProperties().get("jobName");
        this._jobRunId = (String)taskContext.getTask().getProperties().get("jobRunId");
        AnyMap taskParameters = taskContext.getTaskParameters();
        this._dataSource = taskParameters.getStringValue("dataSource");
        this._mapper = PropertyNameMapper.createFrom(taskParameters, normalize);
    }

    public TaskContext getTaskContext() {
        return this._taskContext;
    }

    public String getJobName() {
        return this._jobName;
    }

    public String getJobRunId() {
        return this._jobRunId;
    }

    public String getDataSource() {
        return this._dataSource;
    }

    public PropertyNameMapper getMapper() {
        return this._mapper;
    }

    protected long getNonNegativeParameter(AnyMap taskParameters, String parameterName, long defaultValue) {
        Long parameterValue = taskParameters.getLongValue(parameterName);
        if (parameterValue == null) {
            return defaultValue;
        }
        if (parameterValue < 0L) {
            throw new IllegalArgumentException("Task parameter " + parameterName + " must not be negative.");
        }
        return parameterValue;
    }
}

