/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.worker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.http.client.RestClient;
import org.eclipse.smila.http.client.RestException;
import org.eclipse.smila.http.client.impl.failover.FailoverRestClient;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.DeltaImportStrategy;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.importing.worker.WorkerUsingDeltaService;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class UpdatePusherWorker
extends WorkerUsingDeltaService {
    public static final String DELETE_SHARD_PARAM = "deleteRecordsShard";
    private static final String WORKER_NAME = "updatePusher";
    private static final String INPUT_SLOT_NAME = "recordsToPush";
    private static final String OUTPUT_SLOT_NAME = "pushedRecords";
    private static final String JOB_TO_PUSH_TO_PARAM = "jobToPushTo";
    private static final String CLIENT_PARAMS = "remote";
    private static final String URL_PATH_PARAM = "urlPath";
    private static final String ENDPOINTS_PARAM = "endpoints";
    private BulkbuilderService _bulkbuilder;
    private final Log _log = LogFactory.getLog(this.getClass());

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        String targetJobName = null;
        RestClient client = null;
        String urlPath = null;
        try {
            AnyMap taskParams = taskContext.getTaskParameters();
            if (taskParams.containsKey((Object)JOB_TO_PUSH_TO_PARAM)) {
                targetJobName = this.getRequiredParameter(taskContext, JOB_TO_PUSH_TO_PARAM);
            } else {
                AnyMap clientParams = taskParams.getMap(CLIENT_PARAMS);
                urlPath = clientParams.getStringValue(URL_PATH_PARAM);
                if (urlPath.isEmpty()) {
                    throw new IllegalArgumentException("Invalid parameter 'urlPath' value.");
                }
                client = this.createClient(taskContext, clientParams);
            }
            String jobRunId = this.getJobRunId(taskContext);
            DeltaImportStrategy deltaUsage = this.getDeltaImportStrategy(taskContext);
            if (taskContext.getTask().getProperties().containsKey("isCompletingTask")) {
                if (deltaUsage.isDeltaDeleteEnabled()) {
                    this.deleteObsoleteRecords(taskContext, targetJobName, jobRunId, client, urlPath);
                } else {
                    taskContext.getLog().warn("Got a completion task for a job that has delta-delete disabled. Ignoring this task.");
                }
            } else {
                this.pushUpdatedRecords(taskContext, targetJobName, jobRunId, deltaUsage, client, urlPath);
            }
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    private RestClient createClient(TaskContext taskContext, AnyMap clientParams) {
        AnySeq endpoints = clientParams.getSeq(ENDPOINTS_PARAM);
        ArrayList<String> hostsAndPorts = new ArrayList<String>();
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("Invalid 'endpoints' value.");
        }
        int i = 0;
        while (i < endpoints.size()) {
            hostsAndPorts.add(endpoints.getStringValue(i));
            ++i;
        }
        return new FailoverRestClient(hostsAndPorts);
    }

    private void deleteObsoleteRecords(TaskContext taskContext, String targetJobName, String jobRunId, RestClient client, String urlPath) throws BulkbuilderException, ImportingException {
        String sourceId = this.getRequiredParameter(taskContext, "dataSource");
        String sourceAndShardPrefix = this.getRequiredParameter(taskContext, DELETE_SHARD_PARAM);
        taskContext.addToCounter("deltaDelete.tasks", 1L);
        Collection<DeltaService.EntryId> entryIds = this.getUnvisitedEntriesTimed(jobRunId, sourceAndShardPrefix, taskContext);
        for (DeltaService.EntryId entryId : entryIds) {
            if (taskContext.isCanceled()) {
                return;
            }
            taskContext.addToCounter("deltaDelete.unvisitedRecords", 1L);
            Record deleteRecord = DataFactory.DEFAULT.createRecord(entryId.getRecordId(), sourceId);
            if (client != null) {
                try {
                    client.delete(urlPath, deleteRecord.getMetadata());
                    taskContext.addToCounter("deltaDelete.deletedRecords", 1L);
                    this.deleteDeltaEntryTimed(sourceId, entryId, taskContext);
                    continue;
                }
                catch (RestException ex) {
                    throw new ImportingException("Could not submit delete record '" + entryId + "' to " + urlPath, ex);
                }
                catch (IOException ex) {
                    throw new ImportingException("Could not submit delete record '" + entryId + "' to " + urlPath, ex, true);
                }
            }
            try {
                this._bulkbuilder.deleteRecord(targetJobName, deleteRecord);
                taskContext.addToCounter("deltaDelete.deletedRecords", 1L);
                this.deleteDeltaEntryTimed(sourceId, entryId, taskContext);
            }
            catch (InvalidRecordException ex) {
                taskContext.getLog().warn("Could not submit delete record '" + entryId + "' to bulkbuilder.", (Throwable)ex);
            }
            catch (DeltaException ex) {
                taskContext.getLog().warn("Could not delete entry for record'" + entryId + "' from delta service.", (Throwable)((Object)ex));
            }
        }
    }

    private void pushUpdatedRecords(TaskContext taskContext, String targetJobName, String jobRunId, DeltaImportStrategy deltaUsage, RestClient client, String urlPath) throws ObjectStoreException, IOException, BulkbuilderException, ImportingException {
        Inputs inputs = taskContext.getInputs();
        RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
        Outputs outputs = taskContext.getOutputs();
        RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
        Record record = recordInput.getRecord();
        while (record != null && !taskContext.isCanceled()) {
            String deltaHash = record.getMetadata().getStringValue("_deltaHash");
            if (deltaHash != null) {
                if (deltaUsage.isDeltaCheckDisabled() || this.checkDeltaStateTimed(jobRunId, record, deltaHash, taskContext) != State.UPTODATE) {
                    this.pushToBulkbuilder(taskContext, targetJobName, record, recordOutput, client, urlPath);
                    if (deltaUsage.isSetStateEnabled()) {
                        this.markAsUpdatedTimed(jobRunId, record, deltaHash, taskContext);
                    }
                } else if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Skipping record '" + record.getId() + "'"));
                }
            } else {
                this.pushToBulkbuilder(taskContext, targetJobName, record, recordOutput, client, urlPath);
            }
            record = recordInput.getRecord();
        }
    }

    private void pushToBulkbuilder(TaskContext taskContext, String jobName, Record record, RecordOutput recordOutput, RestClient client, String urlPath) throws BulkbuilderException, ObjectStoreException, IOException, ImportingException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Sending record '" + record.getId() + "'"));
        }
        if (client != null) {
            try {
                client.post(urlPath, record);
            }
            catch (RestException ex) {
                throw new ImportingException("Could not submit record '" + record.getId() + "' to " + urlPath, ex);
            }
            catch (IOException ex) {
                throw new ImportingException("Could not submit record '" + record.getId() + "' to " + urlPath, ex, true);
            }
        }
        try {
            this._bulkbuilder.addRecord(jobName, record);
            if (recordOutput != null) {
                recordOutput.writeRecord(record);
            }
        }
        catch (InvalidRecordException ex) {
            taskContext.getLog().warn("Could not submit record '" + record.getId() + "' to bulkbuilder.", (Throwable)ex);
        }
    }

    public void setBulkbuilderService(BulkbuilderService service) {
        this._bulkbuilder = service;
    }

    public void unsetBulkbuilderService(BulkbuilderService service) {
        if (this._bulkbuilder == service) {
            this._bulkbuilder = null;
        }
    }
}

