/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class SesameRecordReader {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final RepositoryConnection _repoConn;
    private final boolean _includeInferred;
    private Map<String, String> _namespaces;

    public SesameRecordReader(RepositoryConnection repoConn, boolean includeInferred) {
        this._repoConn = repoConn;
        this._includeInferred = includeInferred;
        this.initNamespaces();
    }

    private void initNamespaces() {
        this._namespaces = new HashMap<String, String>();
        try {
            RepositoryResult repoNamespaces = this._repoConn.getNamespaces();
            while (repoNamespaces.hasNext()) {
                Namespace repoNamespace = (Namespace)repoNamespaces.next();
                String repoPrefix = repoNamespace.getPrefix();
                String currentPrefix = this._namespaces.get(repoNamespace.getName());
                if (currentPrefix != null && repoPrefix.length() >= currentPrefix.length()) continue;
                this._namespaces.put(repoNamespace.getName(), repoPrefix);
            }
        }
        catch (RepositoryException repositoryException) {
        }
    }

    public String readBlackboardRecord(URI uri, Blackboard blackboard) throws BlackboardAccessException, RepositoryException {
        String id = this.createId(uri);
        blackboard.getRecord(id, Blackboard.Get.AUTO_CREATE);
        this.readBlackboardRecord(uri, blackboard, id);
        return id;
    }

    public void readBlackboardRecord(URI uri, Blackboard blackboard, String id) throws BlackboardAccessException, RepositoryException {
        Record record = blackboard.getRecord(id);
        this.readRecord(uri, record);
        blackboard.setRecord(record);
    }

    public Record readRecord(URI uri) throws RepositoryException {
        String id = this.createId(uri);
        Record record = DataFactory.DEFAULT.createRecord();
        record.setId(id);
        this.readRecord(uri, record);
        return record;
    }

    public void readRecord(URI uri, Record record) throws RepositoryException {
        record.getMetadata().put("rdf:about", (Any)record.getFactory().createStringValue(uri.stringValue()));
        RepositoryResult statements = this._repoConn.getStatements((Resource)uri, null, null, this._includeInferred, new Resource[0]);
        if (statements != null) {
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                String attributeName = this.uriToString(statement.getPredicate());
                Any value = this.setLiteralValueFromObject(statement, record.getFactory());
                if (!record.getMetadata().containsKey((Object)attributeName)) {
                    record.getMetadata().put(attributeName, value);
                    continue;
                }
                Any oldValue = (Any)record.getMetadata().get((Object)attributeName);
                if (oldValue.isSeq()) {
                    if (value.isSeq()) {
                        for (Any any : (AnySeq)value) {
                            ((AnySeq)oldValue).add((Object)any);
                        }
                    } else {
                        ((AnySeq)oldValue).add((Object)value);
                    }
                    record.getMetadata().put(attributeName, oldValue);
                }
                if (oldValue.isValue() || oldValue.isMap() && !value.isMap()) {
                    AnySeq seq = record.getFactory().createAnySeq();
                    seq.add((Object)oldValue);
                    seq.add((Object)value);
                    record.getMetadata().put(attributeName, (Any)seq);
                    continue;
                }
                if (oldValue.isMap() && value.isMap()) {
                    ((AnyMap)oldValue).putAll((Map)((AnyMap)value));
                    record.getMetadata().put(attributeName, oldValue);
                    continue;
                }
                this._log.error((Object)("Cannot add SESAME statement '" + statement + "' to value '" + oldValue + "'. New value was '" + value + "'."));
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Read metadata: \n" + record.getMetadata().toString()));
            }
        }
    }

    private Any setLiteralValueFromObject(Statement statement, DataFactory dataFactory) {
        org.eclipse.smila.datamodel.Value returnValue;
        Value value = statement.getObject();
        if (value instanceof Resource) {
            returnValue = dataFactory.createStringValue(((Resource)value).stringValue());
        } else {
            org.eclipse.smila.datamodel.Value valueAny = null;
            if (value instanceof Literal) {
                Literal ontoLiteral = (Literal)value;
                URI datatype = ontoLiteral.getDatatype();
                if (datatype != null) {
                    if (XMLDatatypeUtil.isIntegerDatatype((URI)datatype)) {
                        valueAny = dataFactory.createLongValue(Long.valueOf(ontoLiteral.longValue()));
                    } else if (XMLDatatypeUtil.isFloatingPointDatatype((URI)datatype)) {
                        valueAny = dataFactory.createDoubleValue(Double.valueOf(ontoLiteral.doubleValue()));
                    } else if (XMLSchema.BOOLEAN.equals((Object)datatype)) {
                        valueAny = dataFactory.createBooleanValue(Boolean.valueOf(ontoLiteral.booleanValue()));
                    } else if (XMLDatatypeUtil.isCalendarDatatype((URI)datatype)) {
                        XMLGregorianCalendar ontoCal = ontoLiteral.calendarValue();
                        if (XMLSchema.DATETIME.equals((Object)datatype)) {
                            GregorianCalendar cal = ontoCal.toGregorianCalendar();
                            valueAny = dataFactory.createDateTimeValue(cal.getTime());
                        } else if (XMLSchema.TIME.equals((Object)datatype)) {
                            GregorianCalendar cal = ontoCal.toGregorianCalendar();
                            if (this._log.isWarnEnabled()) {
                                this._log.warn((Object)"Creating DATETIME value from TIME literal.");
                            }
                            valueAny = dataFactory.createDateTimeValue(cal.getTime());
                        } else {
                            Calendar cal = this.getDateOnly(ontoCal);
                            valueAny = dataFactory.createDateValue(cal.getTime());
                        }
                    }
                }
                if (ontoLiteral.getLanguage() != null && valueAny != null) {
                    AnyMap tmp = dataFactory.createAnyMap();
                    tmp.put(ontoLiteral.getLanguage(), (Any)valueAny);
                    valueAny = tmp;
                }
            }
            returnValue = valueAny != null ? valueAny : dataFactory.createStringValue(value.stringValue());
        }
        return returnValue;
    }

    private Calendar getDateOnly(XMLGregorianCalendar ontoCal) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        if (ontoCal.getYear() != Integer.MIN_VALUE) {
            cal.set(1, ontoCal.getYear());
        }
        if (ontoCal.getMonth() != Integer.MIN_VALUE) {
            cal.set(2, ontoCal.getMonth() - 1);
        }
        if (ontoCal.getDay() != Integer.MIN_VALUE) {
            cal.set(5, ontoCal.getDay());
        }
        return cal;
    }

    private String createId(URI uri) {
        return uri.stringValue();
    }

    private String uriToString(URI uri) {
        String prefix = this._namespaces.get(uri.getNamespace());
        if (prefix != null) {
            return String.valueOf(prefix) + ":" + uri.getLocalName();
        }
        return uri.stringValue();
    }
}

