/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.RelationId;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;

public class SecondaryRow
extends RowImpl {
    private OpenJPAStateManager[] _fks = null;
    private ColumnIO[] _fkIO = null;
    private OpenJPAStateManager[] _rels = null;
    private RelationId[] _callbacks = null;

    public SecondaryRow(Table table, int action) {
        this(table.getColumns(), action);
    }

    protected SecondaryRow(Column[] cols, int action) {
        super(cols, action);
    }

    public void setForeignKey(ForeignKey fk, OpenJPAStateManager sm) throws SQLException {
        this.setForeignKey(fk, null, sm);
    }

    public void setForeignKey(ForeignKey fk, ColumnIO io, OpenJPAStateManager sm) throws SQLException {
        if (!this.delayForeignKey(fk, sm)) {
            super.setForeignKey(fk, io, sm);
            return;
        }
        if (this.canSetAny(io, fk.getColumns().length + fk.getConstantColumns().length, false)) {
            this.setValid(true);
        }
        if (this._fks == null) {
            this._fks = new OpenJPAStateManager[this.getTable().getForeignKeys().length];
        }
        this._fks[fk.getIndex()] = sm;
        if (this._fkIO != null) {
            this._fkIO[fk.getIndex()] = io;
        } else if (io != null && (this.getAction() == 1 && !io.isAllInsertable(fk, false) || this.getAction() != 1 && !io.isAllUpdatable(fk, false))) {
            this._fkIO = new ColumnIO[this._fks.length];
            this._fkIO[fk.getIndex()] = io;
        }
    }

    private boolean delayForeignKey(ForeignKey fk, OpenJPAStateManager sm) {
        return fk.isPrimaryKeyAutoAssigned() && this.getAction() != 2 && sm != null && sm.isNew() && !sm.isFlushed();
    }

    public void setRelationId(Column col, OpenJPAStateManager sm, RelationId rel) throws SQLException {
        if (sm == null || sm.getObjectId() != null || !sm.isNew() || sm.isFlushed() || !SecondaryRow.isPrimaryKeyAutoAssigned(sm)) {
            super.setRelationId(col, sm, rel);
        } else {
            if (this._rels == null) {
                Column[] cols = this.getTable().getRelationIdColumns();
                this._rels = new OpenJPAStateManager[cols.length];
                this._callbacks = new RelationId[cols.length];
            }
            int idx = this.getRelationIdIndex(col);
            this._rels[idx] = sm;
            this._callbacks[idx] = rel;
        }
    }

    private int getRelationIdIndex(Column col) {
        Column[] cols = this.getTable().getRelationIdColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] != col) continue;
            return i;
        }
        return -1;
    }

    private static boolean isPrimaryKeyAutoAssigned(OpenJPAStateManager sm) {
        ClassMapping cls = (ClassMapping)sm.getMetaData();
        while (cls.getJoinablePCSuperclassMapping() != null) {
            cls = cls.getJoinablePCSuperclassMapping();
        }
        Column[] cols = cls.getPrimaryKeyColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isAutoAssigned()) continue;
            return true;
        }
        return false;
    }

    protected String generateSQL(DBDictionary dict) {
        try {
            if (this._fks != null) {
                ForeignKey[] fks = this.getTable().getForeignKeys();
                for (int i = 0; i < this._fks.length; ++i) {
                    if (this._fks[i] == null) continue;
                    ColumnIO io = this._fkIO == null ? null : this._fkIO[i];
                    super.setForeignKey(fks[i], io, this._fks[i]);
                }
            }
            if (this._rels != null) {
                Column[] cols = this.getTable().getRelationIdColumns();
                for (int i = 0; i < this._rels.length; ++i) {
                    if (this._rels[i] == null) continue;
                    super.setRelationId(cols[i], this._rels[i], this._callbacks[i]);
                }
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, dict);
        }
        return super.generateSQL(dict);
    }

    protected RowImpl newInstance(Column[] cols, int action) {
        return new SecondaryRow(cols, action);
    }

    public void copyInto(RowImpl row, boolean whereOnly) {
        super.copyInto(row, whereOnly);
        if (this._fks == null || whereOnly || row.getAction() == 2 || !(row instanceof SecondaryRow)) {
            return;
        }
        SecondaryRow srow = (SecondaryRow)row;
        if (srow._fks == null) {
            srow._fks = new OpenJPAStateManager[this._fks.length];
        }
        System.arraycopy(this._fks, 0, srow._fks, 0, this._fks.length);
        if (this._fkIO != null) {
            if (srow._fkIO == null) {
                srow._fkIO = new ColumnIO[this._fkIO.length];
            }
            System.arraycopy(this._fkIO, 0, srow._fkIO, 0, this._fkIO.length);
        }
    }
}

