/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.utils.xml.NullPrintWriter;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;

public class TidyPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_TIDY_FILE = "tidyFile";
    private Tidy _tidy;

    public void configure(AnyMap configuration) throws ProcessingException {
        super.configure(configuration);
        String tidyFile = configuration.getStringValue(PROP_TIDY_FILE);
        this._tidy = new Tidy();
        if (tidyFile != null) {
            File f = new File(tidyFile);
            if (!f.exists()) {
                throw new ProcessingException("unable to load tidy configuration file [" + tidyFile + "]");
            }
            this._tidy.setConfigurationFromFile(tidyFile);
        } else {
            this._tidy.setXHTML(true);
            this._tidy.setQuiet(true);
            this._tidy.setErrout((PrintWriter)new NullPrintWriter());
        }
    }

    @Override
    protected void processRecord(Blackboard blackboard, ParameterAccessor paramAccessor, String id) throws Exception {
        ByteArrayInputStream bais = null;
        try {
            byte[] input = this.readInput(blackboard, id, paramAccessor);
            if (input != null && input.length > 0) {
                bais = new ByteArrayInputStream(input);
                Document result = this._tidy.parseDOM((InputStream)bais, null);
                this.storeDocument(blackboard, id, result, paramAccessor);
            }
        }
        finally {
            block10: {
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException e) {
                        if (!this._log.isWarnEnabled()) break block10;
                        this._log.warn((Object)"error closing tidy InputStream", (Throwable)e);
                    }
                }
            }
        }
    }
}

