/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.json.JsonFactory;

public class IpcRecordWriter {
    private static final String ATTACHMENT_NAMES = "_attachmentNames";
    private final IpcFactory _binaryFactory = new BinaryFactory();
    private final IpcAnyWriter _ipcAnyWriter = new IpcAnyWriter();
    private final IpcFactory _jsonFactory;

    public IpcRecordWriter() {
        this(false);
    }

    public IpcRecordWriter(boolean printPretty) {
        this._jsonFactory = new JsonFactory(printPretty);
    }

    public byte[] writeBinaryObject(Record record) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.writeBinaryStream(record, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void writeBinaryStream(Record record, OutputStream stream) throws IOException {
        IpcStreamWriter writer = this._binaryFactory.newStreamWriter(stream);
        this.writeStreamWithAttachments(record, writer);
    }

    public String writeJsonObject(Record record) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.writeJsonStream(record, baos);
            String string = baos.toString("UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void writeJsonStream(Record record, OutputStream stream) throws IOException {
        IpcStreamWriter writer = this._jsonFactory.newStreamWriter(stream);
        this.writeStreamWithoutAttachments(record, writer);
    }

    public void writeStream(Record record, IpcStreamWriter writer) throws IOException {
        if (writer.hasBinarySupport()) {
            this.writeStreamWithAttachments(record, writer);
        } else {
            this.writeStreamWithoutAttachments(record, writer);
        }
    }

    private void writeStreamWithoutAttachments(Record record, IpcStreamWriter writer) throws IOException {
        try {
            writer.writeObjectStart();
            AnyMap recordMetadata = record.getMetadata();
            if (record.hasAttachments()) {
                Iterator<String> attNames = record.getAttachmentNames();
                while (attNames.hasNext()) {
                    recordMetadata.add(ATTACHMENT_NAMES, recordMetadata.getFactory().createStringValue(attNames.next()));
                }
                this._ipcAnyWriter.writeAny(writer, recordMetadata);
                recordMetadata.remove(ATTACHMENT_NAMES);
            } else {
                this._ipcAnyWriter.writeAny(writer, recordMetadata);
            }
            writer.writeObjectEnd();
        }
        finally {
            writer.closeWithoutStream();
        }
    }

    private void writeStreamWithAttachments(Record record, IpcStreamWriter writer) throws IOException {
        writer.writeObjectStart();
        AnyMap recordMetadata = record.getMetadata();
        this._ipcAnyWriter.writeAny(writer, recordMetadata);
        if (record.hasAttachments()) {
            this.writeAttachments(record, writer);
        }
        writer.writeObjectEnd();
    }

    private void writeAttachments(Record record, IpcStreamWriter writer) throws IOException {
        writer.writeAttachmentsStart();
        Iterator<String> attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = attachmentNames.next();
            writer.writeScalarString(attachmentName);
            if (record.getAttachmentAsBytes(attachmentName) != null) {
                writer.writeBinary(record.getAttachmentAsBytes(attachmentName));
                continue;
            }
            throw new IllegalArgumentException("Can't stream record attachment with <null> value for record with id " + record.getId());
        }
        writer.writeAttachmentsEnd();
    }
}

