/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;

public final class RecordMerger {
    public static void mergeRecords(Record to, Record from, boolean mergeExistingAttributes) {
        String toId = to.getId();
        if (mergeExistingAttributes) {
            RecordMerger.mergeMetadata(to.getMetadata(), from.getMetadata());
        } else {
            to.getMetadata().putAll(from.getMetadata());
        }
        if (toId != null) {
            to.setId(toId);
        }
        Iterator<String> attachmentNames = from.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachName = attachmentNames.next();
            to.setAttachment(attachName, from.getAttachmentAsBytes(attachName));
        }
    }

    private static void mergeMetadata(AnyMap to, AnyMap from) {
        for (Map.Entry entry : from.entrySet()) {
            String fromKey = (String)entry.getKey();
            if (to.containsKey(fromKey)) {
                Any resultValue = (Any)to.get(fromKey);
                Any valuesToMerge = (Any)entry.getValue();
                if (valuesToMerge.isValue() || valuesToMerge.isSeq()) {
                    if (resultValue.isSeq()) {
                        resultValue.asSeq().addAll(valuesToMerge.asSeq());
                        continue;
                    }
                    if (!resultValue.isValue()) continue;
                    AnySeq newSeq = resultValue.asSeq();
                    newSeq.addAll(valuesToMerge.asSeq());
                    to.put(fromKey, newSeq);
                    continue;
                }
                if (!resultValue.isMap() || !valuesToMerge.isMap()) continue;
                RecordMerger.mergeMaps(resultValue.asMap(), valuesToMerge.asMap());
                continue;
            }
            to.put(fromKey, (Any)from.get(fromKey));
        }
    }

    private static void mergeMaps(AnyMap to, AnyMap from) {
        to.putAll(from);
    }
}

