/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsl;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.ode.utils.xsl.XslTransformException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XslTransformHandler {
    private static XslTransformHandler __singleton;
    private TransformerFactory _transformerFactory = null;
    private final HashMap<MultiKey, Templates> _templateCache = new HashMap();

    public static synchronized XslTransformHandler getInstance() {
        if (__singleton == null) {
            __singleton = new XslTransformHandler();
        }
        return __singleton;
    }

    private XslTransformHandler() {
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this._transformerFactory = transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXSLSheet(URI uRI, URI uRI2, String string, URIResolver uRIResolver) {
        Templates templates;
        try {
            this._transformerFactory.setURIResolver(uRIResolver);
            templates = this._transformerFactory.newTemplates(new StreamSource(new StringReader(string)));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XslTransformException(transformerConfigurationException);
        }
        HashMap<MultiKey, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            this._templateCache.put(new MultiKey((Object)uRI, (Object)uRI2), templates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheXSLSheet(URI uRI, URI uRI2, String string, URIResolver uRIResolver) {
        Templates templates;
        HashMap<MultiKey, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            templates = this._templateCache.get(new MultiKey((Object)uRI, (Object)uRI2));
        }
        if (templates == null) {
            this.parseXSLSheet(uRI, uRI2, string, uRIResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(URI uRI, URI uRI2, Source source, Map<QName, Object> map, URIResolver uRIResolver) {
        Templates templates;
        Object object = this._templateCache;
        synchronized (object) {
            templates = this._templateCache.get(new MultiKey((Object)uRI, (Object)uRI2));
        }
        if (templates == null) {
            throw new XslTransformException("XSL sheet" + uRI2 + " has not been parsed before transformation!");
        }
        try {
            Object object2;
            Object object3;
            object = templates.newTransformer();
            ((Transformer)object).setURIResolver(uRIResolver);
            if (map != null) {
                object3 = map.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    ((Transformer)object).setParameter(((QName)object2.getKey()).getLocalPart(), object2.getValue());
                }
            }
            if ((object3 = ((Transformer)object).getOutputProperties().getProperty("method")) == null || ((String)object3).equals("xml") || ((String)object3).equals("html")) {
                object2 = new DOMResult();
                ((Transformer)object).transform(source, (Result)object2);
                Node node = ((DOMResult)object2).getNode();
                if (node.getNodeType() == 9) {
                    node = ((Document)node).getDocumentElement();
                }
                return node;
            }
            object2 = new StringWriter();
            StreamResult streamResult = new StreamResult((Writer)object2);
            ((Transformer)object).transform(source, streamResult);
            ((StringWriter)object2).flush();
            return ((StringWriter)object2).toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XslTransformException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XslTransformException("XSL Transformation failed!", transformerException);
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        this._transformerFactory.setErrorListener(errorListener);
    }
}

