/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.impl.DefaultDataFactoryImpl;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.ARequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.solr.Activator;
import org.eclipse.smila.solr.admin.SolrAdministration;
import org.eclipse.smila.solr.admin.SolrAdministrationException;

public class SolrAdministrationHandler
extends ARequestHandler {
    public void handle(HttpExchange exchange) throws IOException {
        try {
            String method = exchange.getRequestMethod();
            Any result = null;
            if (StringUtils.equalsIgnoreCase((String)"GET", (String)method)) {
                result = this.doGet(exchange);
            } else if (StringUtils.equalsIgnoreCase((String)"POST", (String)method)) {
                result = this.doPost(exchange);
            } else {
                String msg = String.format("HttpMethod must be GET . HttpMethod '%s' is unsupported by SolrAdministrationHandler", method);
                throw new UnsupportedMethodException(msg);
            }
            this.sendResponse(exchange, result);
        }
        catch (Exception exception) {
            this.sendError(exchange, exception);
        }
    }

    private Any doGet(HttpExchange exchange) throws Exception {
        GetCommand command = this.getGetCommand(exchange.getRequestURI());
        SolrAdministration administration = this.getSolrAdministration();
        Map parameter = exchange.getParameterMap();
        Any response = null;
        switch (command) {
            case CORENAMES: {
                List<String> coreNames = administration.getCoreNames();
                response = AnyUtil.objectToAny(coreNames);
                break;
            }
            case FIELDNAMES: {
                String core = this.getParameter("core", parameter);
                this.assertRequiredParameterNotNull(core, "core");
                List<String> fieldNames = administration.getFieldNames(core);
                response = AnyUtil.objectToAny(fieldNames);
                break;
            }
            default: {
                throw new NotImplementedException("Command: " + (Object)((Object)command));
            }
        }
        return response;
    }

    private Any doPost(HttpExchange exchange) throws MissingParameterException, SolrAdministrationException, SolrServerException, IOException {
        PostCommand command = this.getPostCommand(exchange.getRequestURI());
        SolrAdministration administration = this.getSolrAdministration();
        Map parameter = exchange.getParameterMap();
        String core = this.getParameter("core", parameter);
        String other = this.getParameter("other", parameter);
        AnyMap response = null;
        switch (command) {
            case STATUS: {
                if (core != null) {
                    response = administration.status(core);
                    break;
                }
                response = administration.status();
                break;
            }
            case CREATE: {
                String name = this.getParameter("name", parameter);
                this.assertRequiredParameterNotNull(name, "name");
                String instanceDir = this.getParameter("instanceDir", parameter);
                this.assertRequiredParameterNotNull(instanceDir, "instanceDir");
                response = administration.create(name, instanceDir, parameter);
                break;
            }
            case RELOAD: {
                this.assertRequiredParameterNotNull(core, "core");
                response = administration.reload(core);
                break;
            }
            case RENAME: {
                this.assertRequiredParameterNotNull(core, "core");
                this.assertRequiredParameterNotNull(other, "other");
                response = administration.rename(core, other);
                break;
            }
            case SWAP: {
                this.assertRequiredParameterNotNull(core, "core");
                this.assertRequiredParameterNotNull(other, "other");
                response = administration.swap(core, other);
                break;
            }
            case UNLOAD: {
                this.assertRequiredParameterNotNull(core, "core");
                String deleteIndexString = this.getParameter("deleteIndex", parameter);
                boolean deleteIndex = BooleanUtils.toBoolean((String)deleteIndexString);
                response = administration.unload(core, deleteIndex);
                break;
            }
            case LOAD: {
                this.assertRequiredParameterNotNull(core, "core");
                response = administration.load(core);
                break;
            }
            case MERGE: {
                this.assertRequiredParameterNotNull(core, "core");
                String[] sourceCore = (String[])parameter.get("srcCore");
                this.assertRequiredParametersNotNull(sourceCore, "srcCore");
                response = administration.mergeIndexes(core, sourceCore);
                break;
            }
            case CLEARCORECACHE: {
                if (core != null) {
                    administration.clearCoreCache(core);
                    break;
                }
                administration.clearCoreCaches();
                break;
            }
            case OPTIMIZE: {
                this.assertRequiredParameterNotNull(core, "core");
                response = administration.optimize(core);
                break;
            }
            case PING: {
                this.assertRequiredParameterNotNull(core, "core");
                response = administration.ping(core);
                break;
            }
            default: {
                throw new NotImplementedException("Command: " + (Object)((Object)command));
            }
        }
        return response;
    }

    private GetCommand getGetCommand(String requestUri) throws MalformedURLException {
        String command;
        List dynamicUriParts = this.getDynamicUriParts(requestUri);
        String string = command = CollectionUtils.isEmpty((Collection)dynamicUriParts) ? null : (String)dynamicUriParts.get(0);
        if (StringUtils.isBlank((String)command)) {
            throw new MalformedURLException("RequestUri must contain command.");
        }
        try {
            return GetCommand.valueOf(command.toUpperCase());
        }
        catch (Exception exception) {
            String allowed = StringUtils.join((Object[])GetCommand.values(), (String)" ");
            String msg = MessageFormat.format("Invalid get command: {0}. Valid commands are: {1}", command, allowed);
            throw new IllegalArgumentException(msg, exception);
        }
    }

    private PostCommand getPostCommand(String requestUri) throws MalformedURLException {
        String command;
        List dynamicUriParts = this.getDynamicUriParts(requestUri);
        String string = command = CollectionUtils.isEmpty((Collection)dynamicUriParts) ? null : (String)dynamicUriParts.get(0);
        if (StringUtils.isBlank((String)command)) {
            throw new MalformedURLException("RequestUri must contain command.");
        }
        try {
            return PostCommand.valueOf(command.toUpperCase());
        }
        catch (Exception exception) {
            String allowed = StringUtils.join((Object[])PostCommand.values(), (String)" ");
            String msg = MessageFormat.format("Invalid post command: {0}. Valid commands are: {1}.", command, allowed);
            throw new IllegalArgumentException(msg, exception);
        }
    }

    private void assertRequiredParameterNotNull(String parameter, String name) throws MissingParameterException {
        if (parameter == null) {
            String msg = MessageFormat.format("Required paramter {0} must not be null", name);
            throw new MissingParameterException(msg);
        }
    }

    private void assertRequiredParametersNotNull(String[] parameters, String name) throws MissingParameterException {
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            String msg = MessageFormat.format("Required paramter array {0} must not be null", name);
            throw new MissingParameterException(msg);
        }
    }

    private String getParameter(String name, Map<String, String[]> parameter) {
        Object[] values = parameter.get(name);
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        return values[0];
    }

    private void sendResponse(HttpExchange exchange, Any result) throws IOException {
        OutputStream responseStream = exchange.getResponseStream();
        Record record = new DefaultDataFactoryImpl().createRecord();
        record.getMetadata().put("administration", result);
        String xml = XmlSerializationUtils.serialize2string((Record)record);
        responseStream.write(xml.getBytes("UTF-8"));
        exchange.setResponseHeader("Content-Type", "text/xml;charset=UTF-8");
        exchange.setResponseStatus(200);
        responseStream.flush();
    }

    private void sendError(HttpExchange exchange, Throwable exception) throws IOException {
        String fullStackTrace = ExceptionUtils.getFullStackTrace((Throwable)exception);
        OutputStream errorStream = exchange.getResponseStream();
        errorStream.write(fullStackTrace.getBytes());
        exchange.setResponseHeader("Content-Type", "text");
        if (exception instanceof UnsupportedMethodException || exception instanceof MissingParameterException) {
            exchange.setResponseStatus(400);
        } else {
            exchange.setResponseStatus(500);
        }
        errorStream.flush();
    }

    private SolrAdministration getSolrAdministration() {
        return Activator.getInstance().getSolrManager().getSolrAdministration();
    }

    static enum GetCommand {
        CORENAMES,
        FIELDNAMES;

    }

    static enum PostCommand {
        STATUS,
        CREATE,
        RELOAD,
        RENAME,
        SWAP,
        UNLOAD,
        LOAD,
        MERGE,
        OPTIMIZE,
        PING,
        CLEARCORECACHE;

    }
}

