/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.common.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/** interface and some standard implementors for collecting messages. */
public interface MessageCollector {
  /** handle a message. */
  void add(String message);

  /** write messages as warnings to log file using the given class. */
  class LogWarn implements MessageCollector {
    private final Log _log;

    public LogWarn(final Class<?> clazz) {
      _log = LogFactory.getLog(clazz);
    }

    @Override
    public void add(final String message) {
      _log.warn(message);
    }
  }

  /** throw away messages. */
  class Ignore implements MessageCollector {
    @Override
    public void add(final String message) {
      ; // throw away
    }
  }
}
