/*********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *********************************************************************************************************************/
package org.eclipse.smila.solr.search;

import org.apache.solr.common.params.SpellingParams;

/**
 * constants used in the result of solr which have not been defined on the solr side in {@link SpellingParams}
 * 
 * @author tmenzel
 * */
public interface SpellcheckSolrConstants extends SpellingParams {

  /** FREQ. */
  String FREQ = "freq";

  /** ORIG_FREQ. */
  String ORIG_FREQ = "origFreq";

  /** END_OFFSET. */
  String END_OFFSET = "endOffset";

  /** START_OFFSET. */
  String START_OFFSET = "startOffset";

  /** NUM_FOUND. */
  String NUM_FOUND = "numFound";

  /** DYM_SUGGESTIONS. */
  String SUGGESTIONS = "suggestions";

  /**
   * Parameter collation.
   */
  String COLLATION = "collation";

  /**
   * Parameter collation.
   */
  String COLLATIONS = "collations";

  /**
   * Parameter spellcheck.
   */
  String SPELLCHECK = "spellcheck";

  /**
   * Parameter collationQueryString.
   */
  String COLLATION_QUERY_STRING = "collationQueryString";

  /**
   * Parameter misspellingsAndCorrections.
   */
  String MISSPELINGS_AND_CORRECTIONS = "misspellingsAndCorrections";

  /**
   * Parameter numberOfHits.
   */
  String NUMER_OF_HITS = "numberOfHits";

  /**
   * Parameter correction.
   */
  String CORRECTION = "correction";

  /**
   * Parameter original.
   */
  String ORIGINAL = "original";

}
