/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - implementation
 **********************************************************************************************************************/
package org.eclipse.smila.processing.bpel;

import java.io.File;
import java.io.IOException;
import java.util.Collection;

import javax.xml.namespace.QName;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.ode.ODEServerException;
import org.eclipse.smila.processing.ProcessingException;
import org.w3c.dom.Element;

/** interface of BpelEngine service. */
public interface BpelEngine {

  /** invoke a pipeline. */
  Element invoke(final String workflowName, final Element message) throws ODEServerException;

  /** check if a workflow is predefined. */
  boolean isPredefinedWorkflow(final String workflowName);

  /** check if a workflow is custom defined. */
  boolean isCustomWorkflow(final String workflowName);

  /** get current workflow definition from ODE server. */
  AnyMap getWorkflow(final String workflowName) throws IOException;

  /**
   * create deployment unit for given workflow definition and validate it.
   * 
   * @return directory ready to deploy.
   * @throws ProcessingException
   *           validation error.
   */
  File validateWorkflow(final String workflowName, final AnyMap workflowDefinition) throws ProcessingException;

  /** deploy a deployment unit dir with one workflow to the server. */
  QName deployWorkflowDir(final String workflowName, final File deploymentDirectory) throws ProcessingException;

  /** undeploy a workflow from the server. */
  void undeployWorkflow(final String workflowName) throws ProcessingException;

  /** deploy a single workflow to the server. */
  void deployWorkflow(final String workflowName, final AnyMap workflowDefinition) throws ProcessingException;

  /**
   * prepare a deployment unit dirrectory from a configuration directory with predefined workflows and deploy it to the
   * server.
   */
  Collection<String> deployPredefinedWorkflows(final String pipelineDirName) throws ProcessingException,
    IOException;

}
