/***********************************************************************************************************************
 * Copyright (c) 2008,2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel;

import java.io.InputStream;

/**
 * Interface of record attachments.
 * 
 * See <a href="http://wiki.eclipse.org/SMILA/Documentation/Data_Model_and_Serialization_Formats">SMILA Data Model</a>
 * for details.
 */
public interface Attachment {

  /**
   * @return name of attachment.
   */
  String getName();

  /**
   * get size of attachments. Result can be negative is the implementation does not know the size.
   * 
   * @return number of bytes in attachment.
   */
  long size();

  /**
   * get attachment content as a byte array.
   * 
   * @return attachment content as a byte[]
   * @throws AttachmentException
   *           if attachment content could not be read to byte array (if not in memory already) or if it is big to fit
   *           in <tt>byte[]</tt>
   */
  byte[] getAsBytes();

  /**
   * get start of attachment content as byte[].
   * 
   * @return first <tt>length</tt> bytes of attachment content.
   * @throws AttachmentException
   *           if attachment content could not be read to byte array (if not in memory already).
   */
  byte[] getAsBytes(int length);

  /**
   * get attachment content for streaming.
   * 
   * @return a stream for reading the attachment.
   * @throws AttachmentException
   *           if no stream could be created.
   */
  InputStream getAsStream();

  /**
   * called to denote that this attachment is not needed anymore and used resources can be released.
   */
  void dispose();
}
