/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Juergen Schumacher (empolis GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.processing;

import org.eclipse.smila.utils.MaybeRecoverableException;

/**
 * Thrown by {@link WorkflowProcessor}s or other processing components on errors while processing a record. The
 * component can set the recoverable flag to true to tell a caller that it is possible that the same call will be
 * successful on retry.
 * 
 * @author jschumacher
 * 
 */
public class ProcessingException extends MaybeRecoverableException {

  /** exceptions are serializable. */
  private static final long serialVersionUID = 2L;

  /** constructor with message. */
  public ProcessingException(final String message) {
    super(message);
  }

  /** constructor with causing exception. */
  public ProcessingException(final Throwable cause) {
    super(cause);
  }

  /** constructor with message and causing exception. */
  public ProcessingException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** constructor with message and recoverable flag. */
  public ProcessingException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** constructor with causing exception and recoverable flag. */
  public ProcessingException(final Throwable cause, final boolean recoverable) {
    super(cause, recoverable);
  }

  /** constructor with message, causing exception and recoverable flag. */
  public ProcessingException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

}
