/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.definitions;

import java.util.Collection;
import java.util.HashSet;


/**
 * Container class for all definitions stored for a job run.
 */
public class JobRunDefinitions {

  /** the job definition of the job run. */
  private JobDefinition _jobDef;

  /** the workflow definition of the job run. */
  private WorkflowDefinition _workflowDef;

  /** the persistent bucket definitions of the job run. */
  private Collection<BucketDefinition> _bucketDefs = new HashSet<BucketDefinition>();

  /**
   * @return the job definition of the job run.
   */
  public JobDefinition getJobDefinition() {
    return _jobDef;
  }

  /**
   * @param jobDef
   *          the job definition of the job run to set.
   */
  public void setJobDefinition(final JobDefinition jobDef) {
    this._jobDef = jobDef;
  }

  /**
   * @return the workflow definition of the job run.
   */
  public WorkflowDefinition getWorkflowDefinition() {
    return _workflowDef;
  }

  /**
   * @param workflowDef
   *          the workflow definition of the job run to set.
   */
  public void setWorkflowDefinition(final WorkflowDefinition workflowDef) {
    this._workflowDef = workflowDef;
  }

  /**
   * @return the bucket definitions of the job run.
   */
  public Collection<BucketDefinition> getBucketDefinitions() {
    return _bucketDefs;
  }

  /**
   * @param bucketDefs
   *          the bucket definitions of the job run to set.
   */
  public void setBucketDefinitions(final Collection<BucketDefinition> bucketDefs) {
    this._bucketDefs = bucketDefs;
  }

  /**
   * @param bucketDef
   *          the bucket definitions of the job run to add.
   */
  public void addBucketDefinition(final BucketDefinition bucketDef) {
    this._bucketDefs.add(bucketDef);
  }

}
